/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListClustersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListClustersResponse.Builder, ListClustersResponse> {
    private final List<ClusterListEntry> clusterListEntries;

    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        this.clusterListEntries = builder.clusterListEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
     *         status information.
     */
    public List<ClusterListEntry> clusterListEntries() {
        return clusterListEntries;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the
     *         array.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterListEntries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse) obj;
        return Objects.equals(clusterListEntries(), other.clusterListEntries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clusterListEntries() != null) {
            sb.append("ClusterListEntries: ").append(clusterListEntries()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterListEntries":
            return Optional.of(clazz.cast(clusterListEntries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListClustersResponse> {
        /**
         * <p>
         * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
         * status information.
         * </p>
         * 
         * @param clusterListEntries
         *        Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other
         *        important status information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries);

        /**
         * <p>
         * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
         * status information.
         * </p>
         * 
         * @param clusterListEntries
         *        Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other
         *        important status information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterListEntries(ClusterListEntry... clusterListEntries);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>ClusterListEntry</code> call, your list of returned clusters will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ClusterListEntry> clusterListEntries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            clusterListEntries(model.clusterListEntries);
            nextToken(model.nextToken);
        }

        public final Collection<ClusterListEntry.Builder> getClusterListEntries() {
            return clusterListEntries != null ? clusterListEntries.stream().map(ClusterListEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copy(clusterListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterListEntries(ClusterListEntry... clusterListEntries) {
            clusterListEntries(Arrays.asList(clusterListEntries));
            return this;
        }

        public final void setClusterListEntries(Collection<ClusterListEntry.BuilderImpl> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copyFromBuilder(clusterListEntries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }
    }
}
