/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.ShipmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Status</code> and <code>TrackingNumber</code> information for an inbound or outbound shipment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Shipment implements StructuredPojo, ToCopyableBuilder<Shipment.Builder, Shipment> {
    private final String status;

    private final String trackingNumber;

    private Shipment(BuilderImpl builder) {
        this.status = builder.status;
        this.trackingNumber = builder.trackingNumber;
    }

    /**
     * <p>
     * Status information for a shipment.
     * </p>
     * 
     * @return Status information for a shipment.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The tracking number for this job. Using this tracking number with your region's carrier's website, you can track
     * a Snowball as the carrier transports it.
     * </p>
     * <p>
     * For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
     * </p>
     * 
     * @return The tracking number for this job. Using this tracking number with your region's carrier's website, you
     *         can track a Snowball as the carrier transports it.</p>
     *         <p>
     *         For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
     */
    public String trackingNumber() {
        return trackingNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(trackingNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shipment)) {
            return false;
        }
        Shipment other = (Shipment) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(trackingNumber(), other.trackingNumber());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (trackingNumber() != null) {
            sb.append("TrackingNumber: ").append(trackingNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "TrackingNumber":
            return Optional.of(clazz.cast(trackingNumber()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShipmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Shipment> {
        /**
         * <p>
         * Status information for a shipment.
         * </p>
         * 
         * @param status
         *        Status information for a shipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The tracking number for this job. Using this tracking number with your region's carrier's website, you can
         * track a Snowball as the carrier transports it.
         * </p>
         * <p>
         * For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
         * </p>
         * 
         * @param trackingNumber
         *        The tracking number for this job. Using this tracking number with your region's carrier's website, you
         *        can track a Snowball as the carrier transports it.</p>
         *        <p>
         *        For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingNumber(String trackingNumber);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String trackingNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Shipment model) {
            status(model.status);
            trackingNumber(model.trackingNumber);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTrackingNumber() {
            return trackingNumber;
        }

        @Override
        public final Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public final void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        @Override
        public Shipment build() {
            return new Shipment(this);
        }
    }
}
