/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.snowball.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * JobMetadata JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class JobMetadataUnmarshaller implements Unmarshaller<JobMetadata, JsonUnmarshallerContext> {

    public JobMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobMetadata.Builder jobMetadataBuilder = JobMetadata.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("JobId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("JobState", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("JobType", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SnowballType", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.snowballType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Resources", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.resources(JobResourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyARN", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.kmsKeyARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.roleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AddressId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.addressId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ShippingDetails", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.shippingDetails(ShippingDetailsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SnowballCapacityPreference", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.snowballCapacityPreference(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Notification", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.notification(NotificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DataTransferProgress", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.dataTransferProgress(DataTransferUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("JobLogInfo", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobLogInfo(JobLogsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.clusterId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ForwardingAddressId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.forwardingAddressId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return jobMetadataBuilder.build();
    }

    private static final JobMetadataUnmarshaller INSTANCE = new JobMetadataUnmarshaller();

    public static JobMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}
