/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KMSRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;
import software.amazon.awssdk.services.snowball.paginators.DescribeAddressesPaginator;
import software.amazon.awssdk.services.snowball.paginators.ListJobsPaginator;
import software.amazon.awssdk.services.snowball.transform.CancelClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelJobResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateAddressResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateJobResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressesResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeJobResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobManifestRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobManifestResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobUnlockCodeRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobUnlockCodeResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSnowballUsageRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSnowballUsageResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClusterJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClusterJobsResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClustersResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListJobsResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobResponseUnmarshaller;

@SdkInternalApi
final class DefaultSnowballClient
implements SnowballClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultSnowballClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public CancelClusterResponse cancelCluster(CancelClusterRequest cancelClusterRequest) throws KMSRequestFailedException, InvalidJobStateException, InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CancelClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelClusterRequest).withMarshaller((Marshaller)new CancelClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CancelJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelJobRequest).withMarshaller((Marshaller)new CancelJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateAddressResponse createAddress(CreateAddressRequest createAddressRequest) throws InvalidAddressException, UnsupportedAddressException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAddressResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAddressRequest).withMarshaller((Marshaller)new CreateAddressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest).withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobRequest).withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAddressResponse describeAddress(DescribeAddressRequest describeAddressRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddressResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAddressRequest).withMarshaller((Marshaller)new DescribeAddressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAddressesResponse describeAddresses(DescribeAddressesRequest describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddressesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeAddressesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAddressesRequest).withMarshaller((Marshaller)new DescribeAddressesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAddressesPaginator describeAddressesIterable(DescribeAddressesRequest describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return new DescribeAddressesPaginator(this, describeAddressesRequest);
    }

    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterRequest).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobRequest).withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetJobManifestResponse getJobManifest(GetJobManifestRequest getJobManifestRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobManifestResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetJobManifestResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobManifestRequest).withMarshaller((Marshaller)new GetJobManifestRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetJobUnlockCodeResponse getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobUnlockCodeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetJobUnlockCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobUnlockCodeRequest).withMarshaller((Marshaller)new GetJobUnlockCodeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSnowballUsageResponse getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) throws SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSnowballUsageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSnowballUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSnowballUsageRequest).withMarshaller((Marshaller)new GetSnowballUsageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListClusterJobsResponse listClusterJobs(ListClusterJobsRequest listClusterJobsRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClusterJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListClusterJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClusterJobsRequest).withMarshaller((Marshaller)new ListClusterJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClustersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClustersRequest).withMarshaller((Marshaller)new ListClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobsPaginator listJobsIterable(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return new ListJobsPaginator(this, listJobsRequest);
    }

    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClusterRequest).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateJobRequest).withMarshaller((Marshaller)new UpdateJobRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(SnowballException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobStateException").withModeledClass(InvalidJobStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceException").withModeledClass(InvalidResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSRequestFailedException").withModeledClass(KMSRequestFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAddressException").withModeledClass(UnsupportedAddressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterLimitExceededException").withModeledClass(ClusterLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputCombinationException").withModeledClass(InvalidInputCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAddressException").withModeledClass(InvalidAddressException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

