/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.snowball.DefaultSnowballClientBuilder;
import software.amazon.awssdk.services.snowball.SnowballClientBuilder;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KMSRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;
import software.amazon.awssdk.services.snowball.paginators.DescribeAddressesPaginator;
import software.amazon.awssdk.services.snowball.paginators.ListJobsPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface SnowballClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "snowball";

    public static SnowballClient create() {
        return (SnowballClient)SnowballClient.builder().build();
    }

    public static SnowballClientBuilder builder() {
        return new DefaultSnowballClientBuilder();
    }

    default public CancelClusterResponse cancelCluster(CancelClusterRequest cancelClusterRequest) throws KMSRequestFailedException, InvalidJobStateException, InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CancelClusterResponse cancelCluster(Consumer<CancelClusterRequest.Builder> cancelClusterRequest) throws KMSRequestFailedException, InvalidJobStateException, InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        return this.cancelCluster((CancelClusterRequest)((Object)((CancelClusterRequest.Builder)CancelClusterRequest.builder().apply(cancelClusterRequest)).build()));
    }

    default public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, SdkBaseException, SdkClientException, SnowballException {
        return this.cancelJob((CancelJobRequest)((Object)((CancelJobRequest.Builder)CancelJobRequest.builder().apply(cancelJobRequest)).build()));
    }

    default public CreateAddressResponse createAddress(CreateAddressRequest createAddressRequest) throws InvalidAddressException, UnsupportedAddressException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CreateAddressResponse createAddress(Consumer<CreateAddressRequest.Builder> createAddressRequest) throws InvalidAddressException, UnsupportedAddressException, SdkBaseException, SdkClientException, SnowballException {
        return this.createAddress((CreateAddressRequest)((Object)((CreateAddressRequest.Builder)CreateAddressRequest.builder().apply(createAddressRequest)).build()));
    }

    default public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        return this.createCluster((CreateClusterRequest)((Object)((CreateClusterRequest.Builder)CreateClusterRequest.builder().apply(createClusterRequest)).build()));
    }

    default public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        return this.createJob((CreateJobRequest)((Object)((CreateJobRequest.Builder)CreateJobRequest.builder().apply(createJobRequest)).build()));
    }

    default public DescribeAddressResponse describeAddress(DescribeAddressRequest describeAddressRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAddressResponse describeAddress(Consumer<DescribeAddressRequest.Builder> describeAddressRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        return this.describeAddress((DescribeAddressRequest)((Object)((DescribeAddressRequest.Builder)DescribeAddressRequest.builder().apply(describeAddressRequest)).build()));
    }

    default public DescribeAddressesResponse describeAddresses() throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.describeAddresses((DescribeAddressesRequest)((Object)DescribeAddressesRequest.builder().build()));
    }

    default public DescribeAddressesResponse describeAddresses(DescribeAddressesRequest describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAddressesResponse describeAddresses(Consumer<DescribeAddressesRequest.Builder> describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.describeAddresses((DescribeAddressesRequest)((Object)((DescribeAddressesRequest.Builder)DescribeAddressesRequest.builder().apply(describeAddressesRequest)).build()));
    }

    default public DescribeAddressesPaginator describeAddressesIterable() throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.describeAddressesIterable((DescribeAddressesRequest)((Object)DescribeAddressesRequest.builder().build()));
    }

    default public DescribeAddressesPaginator describeAddressesIterable(DescribeAddressesRequest describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        return this.describeCluster((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().apply(describeClusterRequest)).build()));
    }

    default public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        return this.describeJob((DescribeJobRequest)((Object)((DescribeJobRequest.Builder)DescribeJobRequest.builder().apply(describeJobRequest)).build()));
    }

    default public GetJobManifestResponse getJobManifest(GetJobManifestRequest getJobManifestRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetJobManifestResponse getJobManifest(Consumer<GetJobManifestRequest.Builder> getJobManifestRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        return this.getJobManifest((GetJobManifestRequest)((Object)((GetJobManifestRequest.Builder)GetJobManifestRequest.builder().apply(getJobManifestRequest)).build()));
    }

    default public GetJobUnlockCodeResponse getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetJobUnlockCodeResponse getJobUnlockCode(Consumer<GetJobUnlockCodeRequest.Builder> getJobUnlockCodeRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        return this.getJobUnlockCode((GetJobUnlockCodeRequest)((Object)((GetJobUnlockCodeRequest.Builder)GetJobUnlockCodeRequest.builder().apply(getJobUnlockCodeRequest)).build()));
    }

    default public GetSnowballUsageResponse getSnowballUsage() throws SdkBaseException, SdkClientException, SnowballException {
        return this.getSnowballUsage((GetSnowballUsageRequest)((Object)GetSnowballUsageRequest.builder().build()));
    }

    default public GetSnowballUsageResponse getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) throws SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetSnowballUsageResponse getSnowballUsage(Consumer<GetSnowballUsageRequest.Builder> getSnowballUsageRequest) throws SdkBaseException, SdkClientException, SnowballException {
        return this.getSnowballUsage((GetSnowballUsageRequest)((Object)((GetSnowballUsageRequest.Builder)GetSnowballUsageRequest.builder().apply(getSnowballUsageRequest)).build()));
    }

    default public ListClusterJobsResponse listClusterJobs(ListClusterJobsRequest listClusterJobsRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListClusterJobsResponse listClusterJobs(Consumer<ListClusterJobsRequest.Builder> listClusterJobsRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.listClusterJobs((ListClusterJobsRequest)((Object)((ListClusterJobsRequest.Builder)ListClusterJobsRequest.builder().apply(listClusterJobsRequest)).build()));
    }

    default public ListClustersResponse listClusters() throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.listClusters((ListClustersRequest)((Object)ListClustersRequest.builder().build()));
    }

    default public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.listClusters((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().apply(listClustersRequest)).build()));
    }

    default public ListJobsResponse listJobs() throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.listJobs((ListJobsRequest)((Object)ListJobsRequest.builder().build()));
    }

    default public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.listJobs((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().apply(listJobsRequest)).build()));
    }

    default public ListJobsPaginator listJobsIterable() throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        return this.listJobsIterable((ListJobsRequest)((Object)ListJobsRequest.builder().build()));
    }

    default public ListJobsPaginator listJobsIterable(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public UpdateClusterResponse updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        return this.updateCluster((UpdateClusterRequest)((Object)((UpdateClusterRequest.Builder)UpdateClusterRequest.builder().apply(updateClusterRequest)).build()));
    }

    default public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public UpdateJobResponse updateJob(Consumer<UpdateJobRequest.Builder> updateJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        return this.updateJob((UpdateJobRequest)((Object)((UpdateJobRequest.Builder)UpdateJobRequest.builder().apply(updateJobRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

