/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.AddressMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The address that you want the Snowball or Snowballs associated with a specific job to be shipped to. Addresses are
 * validated at the time of creation. The address you provide must be located within the serviceable area of your
 * region. Although no individual elements of the <code>Address</code> are required, if the address is invalid or
 * unsupported, then an exception is thrown.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Address implements StructuredPojo, ToCopyableBuilder<Address.Builder, Address> {
    private final String addressId;

    private final String name;

    private final String company;

    private final String street1;

    private final String street2;

    private final String street3;

    private final String city;

    private final String stateOrProvince;

    private final String prefectureOrDistrict;

    private final String landmark;

    private final String country;

    private final String postalCode;

    private final String phoneNumber;

    private final Boolean isRestricted;

    private Address(BuilderImpl builder) {
        this.addressId = builder.addressId;
        this.name = builder.name;
        this.company = builder.company;
        this.street1 = builder.street1;
        this.street2 = builder.street2;
        this.street3 = builder.street3;
        this.city = builder.city;
        this.stateOrProvince = builder.stateOrProvince;
        this.prefectureOrDistrict = builder.prefectureOrDistrict;
        this.landmark = builder.landmark;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
        this.phoneNumber = builder.phoneNumber;
        this.isRestricted = builder.isRestricted;
    }

    /**
     * <p>
     * The unique ID for an address.
     * </p>
     * 
     * @return The unique ID for an address.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The name of a person to receive a Snowball at an address.
     * </p>
     * 
     * @return The name of a person to receive a Snowball at an address.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the company to receive a Snowball at an address.
     * </p>
     * 
     * @return The name of the company to receive a Snowball at an address.
     */
    public String company() {
        return company;
    }

    /**
     * <p>
     * The first line in a street address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The first line in a street address that a Snowball is to be delivered to.
     */
    public String street1() {
        return street1;
    }

    /**
     * <p>
     * The second line in a street address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The second line in a street address that a Snowball is to be delivered to.
     */
    public String street2() {
        return street2;
    }

    /**
     * <p>
     * The third line in a street address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The third line in a street address that a Snowball is to be delivered to.
     */
    public String street3() {
        return street3;
    }

    /**
     * <p>
     * The city in an address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The city in an address that a Snowball is to be delivered to.
     */
    public String city() {
        return city;
    }

    /**
     * <p>
     * The state or province in an address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The state or province in an address that a Snowball is to be delivered to.
     */
    public String stateOrProvince() {
        return stateOrProvince;
    }

    /**
     * <p>
     * This field is no longer used and the value is ignored.
     * </p>
     * 
     * @return This field is no longer used and the value is ignored.
     */
    public String prefectureOrDistrict() {
        return prefectureOrDistrict;
    }

    /**
     * <p>
     * This field is no longer used and the value is ignored.
     * </p>
     * 
     * @return This field is no longer used and the value is ignored.
     */
    public String landmark() {
        return landmark;
    }

    /**
     * <p>
     * The country in an address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The country in an address that a Snowball is to be delivered to.
     */
    public String country() {
        return country;
    }

    /**
     * <p>
     * The postal code in an address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The postal code in an address that a Snowball is to be delivered to.
     */
    public String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The phone number associated with an address that a Snowball is to be delivered to.
     * </p>
     * 
     * @return The phone number associated with an address that a Snowball is to be delivered to.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * If the address you are creating is a primary address, then set this option to true. This field is not supported
     * in most regions.
     * </p>
     * 
     * @return If the address you are creating is a primary address, then set this option to true. This field is not
     *         supported in most regions.
     */
    public Boolean isRestricted() {
        return isRestricted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(company());
        hashCode = 31 * hashCode + Objects.hashCode(street1());
        hashCode = 31 * hashCode + Objects.hashCode(street2());
        hashCode = 31 * hashCode + Objects.hashCode(street3());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrProvince());
        hashCode = 31 * hashCode + Objects.hashCode(prefectureOrDistrict());
        hashCode = 31 * hashCode + Objects.hashCode(landmark());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(isRestricted());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(addressId(), other.addressId()) && Objects.equals(name(), other.name())
                && Objects.equals(company(), other.company()) && Objects.equals(street1(), other.street1())
                && Objects.equals(street2(), other.street2()) && Objects.equals(street3(), other.street3())
                && Objects.equals(city(), other.city()) && Objects.equals(stateOrProvince(), other.stateOrProvince())
                && Objects.equals(prefectureOrDistrict(), other.prefectureOrDistrict())
                && Objects.equals(landmark(), other.landmark()) && Objects.equals(country(), other.country())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(isRestricted(), other.isRestricted());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (addressId() != null) {
            sb.append("AddressId: ").append(addressId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (company() != null) {
            sb.append("Company: ").append(company()).append(",");
        }
        if (street1() != null) {
            sb.append("Street1: ").append(street1()).append(",");
        }
        if (street2() != null) {
            sb.append("Street2: ").append(street2()).append(",");
        }
        if (street3() != null) {
            sb.append("Street3: ").append(street3()).append(",");
        }
        if (city() != null) {
            sb.append("City: ").append(city()).append(",");
        }
        if (stateOrProvince() != null) {
            sb.append("StateOrProvince: ").append(stateOrProvince()).append(",");
        }
        if (prefectureOrDistrict() != null) {
            sb.append("PrefectureOrDistrict: ").append(prefectureOrDistrict()).append(",");
        }
        if (landmark() != null) {
            sb.append("Landmark: ").append(landmark()).append(",");
        }
        if (country() != null) {
            sb.append("Country: ").append(country()).append(",");
        }
        if (postalCode() != null) {
            sb.append("PostalCode: ").append(postalCode()).append(",");
        }
        if (phoneNumber() != null) {
            sb.append("PhoneNumber: ").append(phoneNumber()).append(",");
        }
        if (isRestricted() != null) {
            sb.append("IsRestricted: ").append(isRestricted()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressId":
            return Optional.of(clazz.cast(addressId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Company":
            return Optional.of(clazz.cast(company()));
        case "Street1":
            return Optional.of(clazz.cast(street1()));
        case "Street2":
            return Optional.of(clazz.cast(street2()));
        case "Street3":
            return Optional.of(clazz.cast(street3()));
        case "City":
            return Optional.of(clazz.cast(city()));
        case "StateOrProvince":
            return Optional.of(clazz.cast(stateOrProvince()));
        case "PrefectureOrDistrict":
            return Optional.of(clazz.cast(prefectureOrDistrict()));
        case "Landmark":
            return Optional.of(clazz.cast(landmark()));
        case "Country":
            return Optional.of(clazz.cast(country()));
        case "PostalCode":
            return Optional.of(clazz.cast(postalCode()));
        case "PhoneNumber":
            return Optional.of(clazz.cast(phoneNumber()));
        case "IsRestricted":
            return Optional.of(clazz.cast(isRestricted()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddressMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The unique ID for an address.
         * </p>
         * 
         * @param addressId
         *        The unique ID for an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The name of a person to receive a Snowball at an address.
         * </p>
         * 
         * @param name
         *        The name of a person to receive a Snowball at an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the company to receive a Snowball at an address.
         * </p>
         * 
         * @param company
         *        The name of the company to receive a Snowball at an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder company(String company);

        /**
         * <p>
         * The first line in a street address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param street1
         *        The first line in a street address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street1(String street1);

        /**
         * <p>
         * The second line in a street address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param street2
         *        The second line in a street address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street2(String street2);

        /**
         * <p>
         * The third line in a street address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param street3
         *        The third line in a street address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street3(String street3);

        /**
         * <p>
         * The city in an address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param city
         *        The city in an address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state or province in an address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param stateOrProvince
         *        The state or province in an address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrProvince(String stateOrProvince);

        /**
         * <p>
         * This field is no longer used and the value is ignored.
         * </p>
         * 
         * @param prefectureOrDistrict
         *        This field is no longer used and the value is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefectureOrDistrict(String prefectureOrDistrict);

        /**
         * <p>
         * This field is no longer used and the value is ignored.
         * </p>
         * 
         * @param landmark
         *        This field is no longer used and the value is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landmark(String landmark);

        /**
         * <p>
         * The country in an address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param country
         *        The country in an address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The postal code in an address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param postalCode
         *        The postal code in an address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The phone number associated with an address that a Snowball is to be delivered to.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number associated with an address that a Snowball is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * If the address you are creating is a primary address, then set this option to true. This field is not
         * supported in most regions.
         * </p>
         * 
         * @param isRestricted
         *        If the address you are creating is a primary address, then set this option to true. This field is not
         *        supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRestricted(Boolean isRestricted);
    }

    static final class BuilderImpl implements Builder {
        private String addressId;

        private String name;

        private String company;

        private String street1;

        private String street2;

        private String street3;

        private String city;

        private String stateOrProvince;

        private String prefectureOrDistrict;

        private String landmark;

        private String country;

        private String postalCode;

        private String phoneNumber;

        private Boolean isRestricted;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            addressId(model.addressId);
            name(model.name);
            company(model.company);
            street1(model.street1);
            street2(model.street2);
            street3(model.street3);
            city(model.city);
            stateOrProvince(model.stateOrProvince);
            prefectureOrDistrict(model.prefectureOrDistrict);
            landmark(model.landmark);
            country(model.country);
            postalCode(model.postalCode);
            phoneNumber(model.phoneNumber);
            isRestricted(model.isRestricted);
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCompany() {
            return company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        public final String getStreet1() {
            return street1;
        }

        @Override
        public final Builder street1(String street1) {
            this.street1 = street1;
            return this;
        }

        public final void setStreet1(String street1) {
            this.street1 = street1;
        }

        public final String getStreet2() {
            return street2;
        }

        @Override
        public final Builder street2(String street2) {
            this.street2 = street2;
            return this;
        }

        public final void setStreet2(String street2) {
            this.street2 = street2;
        }

        public final String getStreet3() {
            return street3;
        }

        @Override
        public final Builder street3(String street3) {
            this.street3 = street3;
            return this;
        }

        public final void setStreet3(String street3) {
            this.street3 = street3;
        }

        public final String getCity() {
            return city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getStateOrProvince() {
            return stateOrProvince;
        }

        @Override
        public final Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return this;
        }

        public final void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        public final String getPrefectureOrDistrict() {
            return prefectureOrDistrict;
        }

        @Override
        public final Builder prefectureOrDistrict(String prefectureOrDistrict) {
            this.prefectureOrDistrict = prefectureOrDistrict;
            return this;
        }

        public final void setPrefectureOrDistrict(String prefectureOrDistrict) {
            this.prefectureOrDistrict = prefectureOrDistrict;
        }

        public final String getLandmark() {
            return landmark;
        }

        @Override
        public final Builder landmark(String landmark) {
            this.landmark = landmark;
            return this;
        }

        public final void setLandmark(String landmark) {
            this.landmark = landmark;
        }

        public final String getCountry() {
            return country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final Boolean getIsRestricted() {
            return isRestricted;
        }

        @Override
        public final Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            return this;
        }

        public final void setIsRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
        }

        @Override
        public Address build() {
            return new Address(this);
        }
    }
}
