/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeJobResponse.Builder, DescribeJobResponse> {
    private final JobMetadata jobMetadata;

    private final List<JobMetadata> subJobMetadata;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobMetadata = builder.jobMetadata;
        this.subJobMetadata = builder.subJobMetadata;
    }

    /**
     * <p>
     * Information about a specific job, including shipping information, job status, and other important metadata.
     * </p>
     * 
     * @return Information about a specific job, including shipping information, job status, and other important
     *         metadata.
     */
    public JobMetadata jobMetadata() {
        return jobMetadata;
    }

    /**
     * <p>
     * Information about a specific job part (in the case of an export job), including shipping information, job status,
     * and other important metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about a specific job part (in the case of an export job), including shipping information, job
     *         status, and other important metadata.
     */
    public List<JobMetadata> subJobMetadata() {
        return subJobMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(subJobMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse) obj;
        return Objects.equals(jobMetadata(), other.jobMetadata()) && Objects.equals(subJobMetadata(), other.subJobMetadata());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobMetadata() != null) {
            sb.append("JobMetadata: ").append(jobMetadata()).append(",");
        }
        if (subJobMetadata() != null) {
            sb.append("SubJobMetadata: ").append(subJobMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobMetadata":
            return Optional.of(clazz.cast(jobMetadata()));
        case "SubJobMetadata":
            return Optional.of(clazz.cast(subJobMetadata()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballResponse.Builder, CopyableBuilder<Builder, DescribeJobResponse> {
        /**
         * <p>
         * Information about a specific job, including shipping information, job status, and other important metadata.
         * </p>
         * 
         * @param jobMetadata
         *        Information about a specific job, including shipping information, job status, and other important
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobMetadata(JobMetadata jobMetadata);

        /**
         * <p>
         * Information about a specific job, including shipping information, job status, and other important metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link JobMetadata.Builder} avoiding the need to create
         * one manually via {@link JobMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobMetadata.Builder#build()} is called immediately and its result
         * is passed to {@link #jobMetadata(JobMetadata)}.
         * 
         * @param jobMetadata
         *        a consumer that will call methods on {@link JobMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobMetadata(JobMetadata)
         */
        default Builder jobMetadata(Consumer<JobMetadata.Builder> jobMetadata) {
            return jobMetadata(JobMetadata.builder().apply(jobMetadata).build());
        }

        /**
         * <p>
         * Information about a specific job part (in the case of an export job), including shipping information, job
         * status, and other important metadata.
         * </p>
         * 
         * @param subJobMetadata
         *        Information about a specific job part (in the case of an export job), including shipping information,
         *        job status, and other important metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subJobMetadata(Collection<JobMetadata> subJobMetadata);

        /**
         * <p>
         * Information about a specific job part (in the case of an export job), including shipping information, job
         * status, and other important metadata.
         * </p>
         * 
         * @param subJobMetadata
         *        Information about a specific job part (in the case of an export job), including shipping information,
         *        job status, and other important metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subJobMetadata(JobMetadata... subJobMetadata);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private JobMetadata jobMetadata;

        private List<JobMetadata> subJobMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            jobMetadata(model.jobMetadata);
            subJobMetadata(model.subJobMetadata);
        }

        public final JobMetadata.Builder getJobMetadata() {
            return jobMetadata != null ? jobMetadata.toBuilder() : null;
        }

        @Override
        public final Builder jobMetadata(JobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final void setJobMetadata(JobMetadata.BuilderImpl jobMetadata) {
            this.jobMetadata = jobMetadata != null ? jobMetadata.build() : null;
        }

        public final Collection<JobMetadata.Builder> getSubJobMetadata() {
            return subJobMetadata != null ? subJobMetadata.stream().map(JobMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder subJobMetadata(Collection<JobMetadata> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copy(subJobMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(JobMetadata... subJobMetadata) {
            subJobMetadata(Arrays.asList(subJobMetadata));
            return this;
        }

        public final void setSubJobMetadata(Collection<JobMetadata.BuilderImpl> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copyFromBuilder(subJobMetadata);
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }
    }
}
