/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.AddressMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Address
implements StructuredPojo,
ToCopyableBuilder<Builder, Address> {
    private final String addressId;
    private final String name;
    private final String company;
    private final String street1;
    private final String street2;
    private final String street3;
    private final String city;
    private final String stateOrProvince;
    private final String prefectureOrDistrict;
    private final String landmark;
    private final String country;
    private final String postalCode;
    private final String phoneNumber;
    private final Boolean isRestricted;

    private Address(BuilderImpl builder) {
        this.addressId = builder.addressId;
        this.name = builder.name;
        this.company = builder.company;
        this.street1 = builder.street1;
        this.street2 = builder.street2;
        this.street3 = builder.street3;
        this.city = builder.city;
        this.stateOrProvince = builder.stateOrProvince;
        this.prefectureOrDistrict = builder.prefectureOrDistrict;
        this.landmark = builder.landmark;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
        this.phoneNumber = builder.phoneNumber;
        this.isRestricted = builder.isRestricted;
    }

    public String addressId() {
        return this.addressId;
    }

    public String name() {
        return this.name;
    }

    public String company() {
        return this.company;
    }

    public String street1() {
        return this.street1;
    }

    public String street2() {
        return this.street2;
    }

    public String street3() {
        return this.street3;
    }

    public String city() {
        return this.city;
    }

    public String stateOrProvince() {
        return this.stateOrProvince;
    }

    public String prefectureOrDistrict() {
        return this.prefectureOrDistrict;
    }

    public String landmark() {
        return this.landmark;
    }

    public String country() {
        return this.country;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public Boolean isRestricted() {
        return this.isRestricted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.company());
        hashCode = 31 * hashCode + Objects.hashCode(this.street1());
        hashCode = 31 * hashCode + Objects.hashCode(this.street2());
        hashCode = 31 * hashCode + Objects.hashCode(this.street3());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateOrProvince());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefectureOrDistrict());
        hashCode = 31 * hashCode + Objects.hashCode(this.landmark());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRestricted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.company(), other.company()) && Objects.equals(this.street1(), other.street1()) && Objects.equals(this.street2(), other.street2()) && Objects.equals(this.street3(), other.street3()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.stateOrProvince(), other.stateOrProvince()) && Objects.equals(this.prefectureOrDistrict(), other.prefectureOrDistrict()) && Objects.equals(this.landmark(), other.landmark()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.isRestricted(), other.isRestricted());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.addressId() != null) {
            sb.append("AddressId: ").append(this.addressId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.company() != null) {
            sb.append("Company: ").append(this.company()).append(",");
        }
        if (this.street1() != null) {
            sb.append("Street1: ").append(this.street1()).append(",");
        }
        if (this.street2() != null) {
            sb.append("Street2: ").append(this.street2()).append(",");
        }
        if (this.street3() != null) {
            sb.append("Street3: ").append(this.street3()).append(",");
        }
        if (this.city() != null) {
            sb.append("City: ").append(this.city()).append(",");
        }
        if (this.stateOrProvince() != null) {
            sb.append("StateOrProvince: ").append(this.stateOrProvince()).append(",");
        }
        if (this.prefectureOrDistrict() != null) {
            sb.append("PrefectureOrDistrict: ").append(this.prefectureOrDistrict()).append(",");
        }
        if (this.landmark() != null) {
            sb.append("Landmark: ").append(this.landmark()).append(",");
        }
        if (this.country() != null) {
            sb.append("Country: ").append(this.country()).append(",");
        }
        if (this.postalCode() != null) {
            sb.append("PostalCode: ").append(this.postalCode()).append(",");
        }
        if (this.phoneNumber() != null) {
            sb.append("PhoneNumber: ").append(this.phoneNumber()).append(",");
        }
        if (this.isRestricted() != null) {
            sb.append("IsRestricted: ").append(this.isRestricted()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressId": {
                return Optional.of(clazz.cast(this.addressId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Company": {
                return Optional.of(clazz.cast(this.company()));
            }
            case "Street1": {
                return Optional.of(clazz.cast(this.street1()));
            }
            case "Street2": {
                return Optional.of(clazz.cast(this.street2()));
            }
            case "Street3": {
                return Optional.of(clazz.cast(this.street3()));
            }
            case "City": {
                return Optional.of(clazz.cast(this.city()));
            }
            case "StateOrProvince": {
                return Optional.of(clazz.cast(this.stateOrProvince()));
            }
            case "PrefectureOrDistrict": {
                return Optional.of(clazz.cast(this.prefectureOrDistrict()));
            }
            case "Landmark": {
                return Optional.of(clazz.cast(this.landmark()));
            }
            case "Country": {
                return Optional.of(clazz.cast(this.country()));
            }
            case "PostalCode": {
                return Optional.of(clazz.cast(this.postalCode()));
            }
            case "PhoneNumber": {
                return Optional.of(clazz.cast(this.phoneNumber()));
            }
            case "IsRestricted": {
                return Optional.of(clazz.cast(this.isRestricted()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddressMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressId;
        private String name;
        private String company;
        private String street1;
        private String street2;
        private String street3;
        private String city;
        private String stateOrProvince;
        private String prefectureOrDistrict;
        private String landmark;
        private String country;
        private String postalCode;
        private String phoneNumber;
        private Boolean isRestricted;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.addressId(model.addressId);
            this.name(model.name);
            this.company(model.company);
            this.street1(model.street1);
            this.street2(model.street2);
            this.street3(model.street3);
            this.city(model.city);
            this.stateOrProvince(model.stateOrProvince);
            this.prefectureOrDistrict(model.prefectureOrDistrict);
            this.landmark(model.landmark);
            this.country(model.country);
            this.postalCode(model.postalCode);
            this.phoneNumber(model.phoneNumber);
            this.isRestricted(model.isRestricted);
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCompany() {
            return this.company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        public final String getStreet1() {
            return this.street1;
        }

        @Override
        public final Builder street1(String street1) {
            this.street1 = street1;
            return this;
        }

        public final void setStreet1(String street1) {
            this.street1 = street1;
        }

        public final String getStreet2() {
            return this.street2;
        }

        @Override
        public final Builder street2(String street2) {
            this.street2 = street2;
            return this;
        }

        public final void setStreet2(String street2) {
            this.street2 = street2;
        }

        public final String getStreet3() {
            return this.street3;
        }

        @Override
        public final Builder street3(String street3) {
            this.street3 = street3;
            return this;
        }

        public final void setStreet3(String street3) {
            this.street3 = street3;
        }

        public final String getCity() {
            return this.city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getStateOrProvince() {
            return this.stateOrProvince;
        }

        @Override
        public final Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return this;
        }

        public final void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        public final String getPrefectureOrDistrict() {
            return this.prefectureOrDistrict;
        }

        @Override
        public final Builder prefectureOrDistrict(String prefectureOrDistrict) {
            this.prefectureOrDistrict = prefectureOrDistrict;
            return this;
        }

        public final void setPrefectureOrDistrict(String prefectureOrDistrict) {
            this.prefectureOrDistrict = prefectureOrDistrict;
        }

        public final String getLandmark() {
            return this.landmark;
        }

        @Override
        public final Builder landmark(String landmark) {
            this.landmark = landmark;
            return this;
        }

        public final void setLandmark(String landmark) {
            this.landmark = landmark;
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final Boolean getIsRestricted() {
            return this.isRestricted;
        }

        @Override
        public final Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            return this;
        }

        public final void setIsRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
        }

        public Address build() {
            return new Address(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Address> {
        public Builder addressId(String var1);

        public Builder name(String var1);

        public Builder company(String var1);

        public Builder street1(String var1);

        public Builder street2(String var1);

        public Builder street3(String var1);

        public Builder city(String var1);

        public Builder stateOrProvince(String var1);

        public Builder prefectureOrDistrict(String var1);

        public Builder landmark(String var1);

        public Builder country(String var1);

        public Builder postalCode(String var1);

        public Builder phoneNumber(String var1);

        public Builder isRestricted(Boolean var1);
    }
}

