/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateJobRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private final String jobType;
    private final JobResource resources;
    private final String description;
    private final String addressId;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String snowballCapacityPreference;
    private final String shippingOption;
    private final Notification notification;
    private final String clusterId;
    private final String snowballType;
    private final String forwardingAddressId;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.clusterId = builder.clusterId;
        this.snowballType = builder.snowballType;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeString() {
        return this.jobType;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String description() {
        return this.description;
    }

    public String addressId() {
        return this.addressId;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(this.snowballCapacityPreference);
    }

    public String snowballCapacityPreferenceString() {
        return this.snowballCapacityPreference;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionString() {
        return this.shippingOption;
    }

    public Notification notification() {
        return this.notification;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public String snowballTypeString() {
        return this.snowballType;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballCapacityPreferenceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.jobTypeString(), other.jobTypeString()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.snowballCapacityPreferenceString(), other.snowballCapacityPreferenceString()) && Objects.equals(this.shippingOptionString(), other.shippingOptionString()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.snowballTypeString(), other.snowballTypeString()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobTypeString() != null) {
            sb.append("JobType: ").append(this.jobTypeString()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.addressId() != null) {
            sb.append("AddressId: ").append(this.addressId()).append(",");
        }
        if (this.kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(this.kmsKeyARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.snowballCapacityPreferenceString() != null) {
            sb.append("SnowballCapacityPreference: ").append(this.snowballCapacityPreferenceString()).append(",");
        }
        if (this.shippingOptionString() != null) {
            sb.append("ShippingOption: ").append(this.shippingOptionString()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.snowballTypeString() != null) {
            sb.append("SnowballType: ").append(this.snowballTypeString()).append(",");
        }
        if (this.forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(this.forwardingAddressId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobType": {
                return Optional.of(clazz.cast(this.jobTypeString()));
            }
            case "Resources": {
                return Optional.of(clazz.cast(this.resources()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "AddressId": {
                return Optional.of(clazz.cast(this.addressId()));
            }
            case "KmsKeyARN": {
                return Optional.of(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "SnowballCapacityPreference": {
                return Optional.of(clazz.cast(this.snowballCapacityPreferenceString()));
            }
            case "ShippingOption": {
                return Optional.of(clazz.cast(this.shippingOptionString()));
            }
            case "Notification": {
                return Optional.of(clazz.cast(this.notification()));
            }
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "SnowballType": {
                return Optional.of(clazz.cast(this.snowballTypeString()));
            }
            case "ForwardingAddressId": {
                return Optional.of(clazz.cast(this.forwardingAddressId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String jobType;
        private JobResource resources;
        private String description;
        private String addressId;
        private String kmsKeyARN;
        private String roleARN;
        private String snowballCapacityPreference;
        private String shippingOption;
        private Notification notification;
        private String clusterId;
        private String snowballType;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            this.jobType(model.jobType);
            this.resources(model.resources);
            this.description(model.description);
            this.addressId(model.addressId);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.snowballCapacityPreference(model.snowballCapacityPreference);
            this.shippingOption(model.shippingOption);
            this.notification(model.notification);
            this.clusterId(model.clusterId);
            this.snowballType(model.snowballType);
            this.forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballCapacityPreference() {
            return this.snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().apply(resources)).build());
        }

        public Builder description(String var1);

        public Builder addressId(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().apply(notification)).build());
        }

        public Builder clusterId(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder forwardingAddressId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

