/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAddressResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeAddressResponse.Builder, DescribeAddressResponse> {
    private final Address address;

    private DescribeAddressResponse(BuilderImpl builder) {
        super(builder);
        this.address = builder.address;
    }

    /**
     * <p>
     * The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
     * </p>
     * 
     * @return The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
     */
    public Address address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressResponse)) {
            return false;
        }
        DescribeAddressResponse other = (DescribeAddressResponse) obj;
        return Objects.equals(address(), other.address());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAddressResponse").add("Address", address()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.of(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballResponse.Builder, CopyableBuilder<Builder, DescribeAddressResponse> {
        /**
         * <p>
         * The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
         * </p>
         * 
         * @param address
         *        The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
         * </p>
         * This is a convenience that creates an instance of the {@link Address.Builder} avoiding the need to create one
         * manually via {@link Address#builder()}.
         *
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().apply(address).build());
        }
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private Address address;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressResponse model) {
            address(model.address);
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public DescribeAddressResponse build() {
            return new DescribeAddressResponse(this);
        }
    }
}
