/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAddressesResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeAddressesResponse.Builder, DescribeAddressesResponse> {
    private final List<Address> addresses;

    private final String nextToken;

    private DescribeAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.addresses = builder.addresses;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Snowball shipping addresses that were created for this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Snowball shipping addresses that were created for this account.
     */
    public List<Address> addresses() {
        return addresses;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in
     *         the array.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addresses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse) obj;
        return Objects.equals(addresses(), other.addresses()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAddressesResponse").add("Addresses", addresses()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Addresses":
            return Optional.of(clazz.cast(addresses()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballResponse.Builder, CopyableBuilder<Builder, DescribeAddressesResponse> {
        /**
         * <p>
         * The Snowball shipping addresses that were created for this account.
         * </p>
         * 
         * @param addresses
         *        The Snowball shipping addresses that were created for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<Address> addresses);

        /**
         * <p>
         * The Snowball shipping addresses that were created for this account.
         * </p>
         * 
         * @param addresses
         *        The Snowball shipping addresses that were created for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Address... addresses);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>DescribeAddresses</code> call, your list of returned addresses will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<Address> addresses;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            addresses(model.addresses);
            nextToken(model.nextToken);
        }

        public final Collection<Address.Builder> getAddresses() {
            return addresses != null ? addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }
    }
}
