/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.ClusterState;
import software.amazon.awssdk.services.snowball.transform.ClusterListEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, ClusterListEntry> {
    private final String clusterId;
    private final String clusterState;
    private final Instant creationDate;
    private final String description;

    private ClusterListEntry(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.clusterState = builder.clusterState;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public ClusterState clusterState() {
        return ClusterState.fromValue(this.clusterState);
    }

    public String clusterStateString() {
        return this.clusterState;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterListEntry)) {
            return false;
        }
        ClusterListEntry other = (ClusterListEntry)obj;
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.clusterStateString(), other.clusterStateString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"ClusterListEntry").add("ClusterId", (Object)this.clusterId()).add("ClusterState", (Object)this.clusterStateString()).add("CreationDate", (Object)this.creationDate()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "ClusterState": {
                return Optional.of(clazz.cast(this.clusterStateString()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String clusterState;
        private Instant creationDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterListEntry model) {
            this.clusterId(model.clusterId);
            this.clusterState(model.clusterState);
            this.creationDate(model.creationDate);
            this.description(model.description);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getClusterState() {
            return this.clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState.toString());
            return this;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ClusterListEntry build() {
            return new ClusterListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterListEntry> {
        public Builder clusterId(String var1);

        public Builder clusterState(String var1);

        public Builder clusterState(ClusterState var1);

        public Builder creationDate(Instant var1);

        public Builder description(String var1);
    }
}

