/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.snowball.model.ClusterListEntry;
import software.amazon.awssdk.services.snowball.model.ClusterListEntryListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClustersResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private final List<ClusterListEntry> clusterListEntries;
    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusterListEntries = builder.clusterListEntries;
        this.nextToken = builder.nextToken;
    }

    public List<ClusterListEntry> clusterListEntries() {
        return this.clusterListEntries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterListEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        return Objects.equals(this.clusterListEntries(), other.clusterListEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListClustersResponse").add("ClusterListEntries", this.clusterListEntries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterListEntries": {
                return Optional.of(clazz.cast(this.clusterListEntries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private List<ClusterListEntry> clusterListEntries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            this.clusterListEntries(model.clusterListEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ClusterListEntry.Builder> getClusterListEntries() {
            return this.clusterListEntries != null ? (Collection)this.clusterListEntries.stream().map(ClusterListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copy(clusterListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterListEntries(ClusterListEntry ... clusterListEntries) {
            this.clusterListEntries(Arrays.asList(clusterListEntries));
            return this;
        }

        public final void setClusterListEntries(Collection<ClusterListEntry.BuilderImpl> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copyFromBuilder(clusterListEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    CopyableBuilder<Builder, ListClustersResponse> {
        public Builder clusterListEntries(Collection<ClusterListEntry> var1);

        public Builder clusterListEntries(ClusterListEntry ... var1);

        public Builder nextToken(String var1);
    }
}

