/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.Address;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AddressMarshaller {
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> COMPANY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Company").isBinary(false).build();
    private static final MarshallingInfo<String> STREET1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Street1").isBinary(false).build();
    private static final MarshallingInfo<String> STREET2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Street2").isBinary(false).build();
    private static final MarshallingInfo<String> STREET3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Street3").isBinary(false).build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").isBinary(false).build();
    private static final MarshallingInfo<String> STATEORPROVINCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateOrProvince").isBinary(false).build();
    private static final MarshallingInfo<String> PREFECTUREORDISTRICT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrefectureOrDistrict").isBinary(false).build();
    private static final MarshallingInfo<String> LANDMARK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Landmark").isBinary(false).build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").isBinary(false).build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostalCode").isBinary(false).build();
    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumber").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISRESTRICTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsRestricted").isBinary(false).build();
    private static final AddressMarshaller INSTANCE = new AddressMarshaller();

    private AddressMarshaller() {
    }

    public static AddressMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Address address, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)address, (String)"address");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)address.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)address.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)address.company(), COMPANY_BINDING);
            protocolMarshaller.marshall((Object)address.street1(), STREET1_BINDING);
            protocolMarshaller.marshall((Object)address.street2(), STREET2_BINDING);
            protocolMarshaller.marshall((Object)address.street3(), STREET3_BINDING);
            protocolMarshaller.marshall((Object)address.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)address.stateOrProvince(), STATEORPROVINCE_BINDING);
            protocolMarshaller.marshall((Object)address.prefectureOrDistrict(), PREFECTUREORDISTRICT_BINDING);
            protocolMarshaller.marshall((Object)address.landmark(), LANDMARK_BINDING);
            protocolMarshaller.marshall((Object)address.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)address.postalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)address.phoneNumber(), PHONENUMBER_BINDING);
            protocolMarshaller.marshall((Object)address.isRestricted(), ISRESTRICTED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

