/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.KeyRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyRangeMarshaller {
    private static final MarshallingInfo<String> BEGINMARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginMarker").isBinary(false).build();
    private static final MarshallingInfo<String> ENDMARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndMarker").isBinary(false).build();
    private static final KeyRangeMarshaller INSTANCE = new KeyRangeMarshaller();

    private KeyRangeMarshaller() {
    }

    public static KeyRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyRange keyRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyRange, (String)"keyRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyRange.beginMarker(), BEGINMARKER_BINDING);
            protocolMarshaller.marshall((Object)keyRange.endMarker(), ENDMARKER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

