/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobRequest extends SnowballRequest implements
        ToCopyableBuilder<UpdateJobRequest.Builder, UpdateJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.<Notification> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateJobRequest::notification)).setter(setter(Builder::notification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.<JobResource> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateJobRequest::resources)).setter(setter(Builder::resources)).constructor(JobResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()).build();

    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::addressId)).setter(setter(Builder::addressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()).build();

    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::shippingOptionAsString)).setter(setter(Builder::shippingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::snowballCapacityPreferenceAsString))
            .setter(setter(Builder::snowballCapacityPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build())
            .build();

    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobRequest::forwardingAddressId)).setter(setter(Builder::forwardingAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, ROLE_ARN_FIELD,
            NOTIFICATION_FIELD, RESOURCES_FIELD, ADDRESS_ID_FIELD, SHIPPING_OPTION_FIELD, DESCRIPTION_FIELD,
            SNOWBALL_CAPACITY_PREFERENCE_FIELD, FORWARDING_ADDRESS_ID_FIELD));

    private final String jobId;

    private final String roleARN;

    private final Notification notification;

    private final JobResource resources;

    private final String addressId;

    private final String shippingOption;

    private final String description;

    private final String snowballCapacityPreference;

    private final String forwardingAddressId;

    private UpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.roleARN = builder.roleARN;
        this.notification = builder.notification;
        this.resources = builder.resources;
        this.addressId = builder.addressId;
        this.shippingOption = builder.shippingOption;
        this.description = builder.description;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The job ID of the job that you want to update, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS Identity and
     * Access Management (IAM) API action.
     * </p>
     * 
     * @return The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN,
     *         use the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS Identity
     *         and Access Management (IAM) API action.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The new or updated <a>Notification</a> object.
     * </p>
     * 
     * @return The new or updated <a>Notification</a> object.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The updated <code>JobResource</code> object, or the updated <a>JobResource</a> object.
     * </p>
     * 
     * @return The updated <code>JobResource</code> object, or the updated <a>JobResource</a> object.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * The ID of the updated <a>Address</a> object.
     * </p>
     * 
     * @return The ID of the updated <a>Address</a> object.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * @see ShippingOption
     */
    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * @see ShippingOption
     */
    public String shippingOptionAsString() {
        return shippingOption;
    }

    /**
     * <p>
     * The updated description of this job's <a>JobMetadata</a> object.
     * </p>
     * 
     * @return The updated description of this job's <a>JobMetadata</a> object.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB Snowballs
     * are only available in the US regions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
     *         Snowballs are only available in the US regions.
     * @see SnowballCapacity
     */
    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(snowballCapacityPreference);
    }

    /**
     * <p>
     * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB Snowballs
     * are only available in the US regions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
     *         Snowballs are only available in the US regions.
     * @see SnowballCapacity
     */
    public String snowballCapacityPreferenceAsString() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The updated ID for the forwarding address for a job. This field is not supported in most regions.
     * </p>
     * 
     * @return The updated ID for the forwarding address for a job. This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingAddressId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(notification(), other.notification()) && Objects.equals(resources(), other.resources())
                && Objects.equals(addressId(), other.addressId())
                && Objects.equals(shippingOptionAsString(), other.shippingOptionAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString())
                && Objects.equals(forwardingAddressId(), other.forwardingAddressId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJobRequest").add("JobId", jobId()).add("RoleARN", roleARN())
                .add("Notification", notification()).add("Resources", resources()).add("AddressId", addressId())
                .add("ShippingOption", shippingOptionAsString()).add("Description", description())
                .add("SnowballCapacityPreference", snowballCapacityPreferenceAsString())
                .add("ForwardingAddressId", forwardingAddressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "AddressId":
            return Optional.ofNullable(clazz.cast(addressId()));
        case "ShippingOption":
            return Optional.ofNullable(clazz.cast(shippingOptionAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SnowballCapacityPreference":
            return Optional.ofNullable(clazz.cast(snowballCapacityPreferenceAsString()));
        case "ForwardingAddressId":
            return Optional.ofNullable(clazz.cast(forwardingAddressId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobRequest, T> g) {
        return obj -> g.apply((UpdateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobRequest> {
        /**
         * <p>
         * The job ID of the job that you want to update, for example
         * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The job ID of the job that you want to update, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use
         * the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS
         * Identity and Access Management (IAM) API action.
         * </p>
         * 
         * @param roleARN
         *        The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role
         *        ARN, use the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS
         *        Identity and Access Management (IAM) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The new or updated <a>Notification</a> object.
         * </p>
         * 
         * @param notification
         *        The new or updated <a>Notification</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The new or updated <a>Notification</a> object.
         * </p>
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The updated <code>JobResource</code> object, or the updated <a>JobResource</a> object.
         * </p>
         * 
         * @param resources
         *        The updated <code>JobResource</code> object, or the updated <a>JobResource</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * The updated <code>JobResource</code> object, or the updated <a>JobResource</a> object.
         * </p>
         * This is a convenience that creates an instance of the {@link JobResource.Builder} avoiding the need to create
         * one manually via {@link JobResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobResource.Builder#build()} is called immediately and its result
         * is passed to {@link #resources(JobResource)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link JobResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(JobResource)
         */
        default Builder resources(Consumer<JobResource.Builder> resources) {
            return resources(JobResource.builder().applyMutation(resources).build());
        }

        /**
         * <p>
         * The ID of the updated <a>Address</a> object.
         * </p>
         * 
         * @param addressId
         *        The ID of the updated <a>Address</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * </p>
         * 
         * @param shippingOption
         *        The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * </p>
         * 
         * @param shippingOption
         *        The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The updated description of this job's <a>JobMetadata</a> object.
         * </p>
         * 
         * @param description
         *        The updated description of this job's <a>JobMetadata</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         * Snowballs are only available in the US regions.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         *        Snowballs are only available in the US regions.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         * Snowballs are only available in the US regions.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         *        Snowballs are only available in the US regions.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The updated ID for the forwarding address for a job. This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The updated ID for the forwarding address for a job. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String jobId;

        private String roleARN;

        private Notification notification;

        private JobResource resources;

        private String addressId;

        private String shippingOption;

        private String description;

        private String snowballCapacityPreference;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            super(model);
            jobId(model.jobId);
            roleARN(model.roleARN);
            notification(model.notification);
            resources(model.resources);
            addressId(model.addressId);
            shippingOption(model.shippingOption);
            description(model.description);
            snowballCapacityPreference(model.snowballCapacityPreference);
            forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final JobResource.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getShippingOptionAsString() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSnowballCapacityPreferenceAsString() {
            return snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference == null ? null : snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
