/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that describes a compatible Amazon Machine Image (AMI), including the ID and name for a
 * Snowball Edge AMI. This AMI is compatible with the device's physical hardware requirements, and it should be able to
 * be run in an SBE1 instance on the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompatibleImage implements SdkPojo, Serializable, ToCopyableBuilder<CompatibleImage.Builder, CompatibleImage> {
    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CompatibleImage::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CompatibleImage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_ID_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amiId;

    private final String name;

    private CompatibleImage(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique identifier for an individual Snowball Edge AMI.
     * </p>
     * 
     * @return The unique identifier for an individual Snowball Edge AMI.
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The optional name of a compatible image.
     * </p>
     * 
     * @return The optional name of a compatible image.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleImage)) {
            return false;
        }
        CompatibleImage other = (CompatibleImage) obj;
        return Objects.equals(amiId(), other.amiId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CompatibleImage").add("AmiId", amiId()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompatibleImage, T> g) {
        return obj -> g.apply((CompatibleImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompatibleImage> {
        /**
         * <p>
         * The unique identifier for an individual Snowball Edge AMI.
         * </p>
         * 
         * @param amiId
         *        The unique identifier for an individual Snowball Edge AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The optional name of a compatible image.
         * </p>
         * 
         * @param name
         *        The optional name of a compatible image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String amiId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleImage model) {
            amiId(model.amiId);
            name(model.name);
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public CompatibleImage build() {
            return new CompatibleImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
