/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobUnlockCodeResponse extends SnowballResponse implements
        ToCopyableBuilder<GetJobUnlockCodeResponse.Builder, GetJobUnlockCodeResponse> {
    private static final SdkField<String> UNLOCK_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetJobUnlockCodeResponse::unlockCode)).setter(setter(Builder::unlockCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnlockCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNLOCK_CODE_FIELD));

    private final String unlockCode;

    private GetJobUnlockCodeResponse(BuilderImpl builder) {
        super(builder);
        this.unlockCode = builder.unlockCode;
    }

    /**
     * <p>
     * The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be accessed for up
     * to 90 days after the job has been created.
     * </p>
     * 
     * @return The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be
     *         accessed for up to 90 days after the job has been created.
     */
    public String unlockCode() {
        return unlockCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(unlockCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobUnlockCodeResponse)) {
            return false;
        }
        GetJobUnlockCodeResponse other = (GetJobUnlockCodeResponse) obj;
        return Objects.equals(unlockCode(), other.unlockCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetJobUnlockCodeResponse").add("UnlockCode", unlockCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnlockCode":
            return Optional.ofNullable(clazz.cast(unlockCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobUnlockCodeResponse, T> g) {
        return obj -> g.apply((GetJobUnlockCodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobUnlockCodeResponse> {
        /**
         * <p>
         * The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be accessed
         * for up to 90 days after the job has been created.
         * </p>
         * 
         * @param unlockCode
         *        The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be
         *        accessed for up to 90 days after the job has been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlockCode(String unlockCode);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String unlockCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobUnlockCodeResponse model) {
            super(model);
            unlockCode(model.unlockCode);
        }

        public final String getUnlockCode() {
            return unlockCode;
        }

        @Override
        public final Builder unlockCode(String unlockCode) {
            this.unlockCode = unlockCode;
            return this;
        }

        public final void setUnlockCode(String unlockCode) {
            this.unlockCode = unlockCode;
        }

        @Override
        public GetJobUnlockCodeResponse build() {
            return new GetJobUnlockCodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
