/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSoftwareUpdatesResponse extends SnowballResponse implements
        ToCopyableBuilder<GetSoftwareUpdatesResponse.Builder, GetSoftwareUpdatesResponse> {
    private static final SdkField<String> UPDATES_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSoftwareUpdatesResponse::updatesURI)).setter(setter(Builder::updatesURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatesURI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATES_URI_FIELD));

    private final String updatesURI;

    private GetSoftwareUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.updatesURI = builder.updatesURI;
    }

    /**
     * <p>
     * The Amazon S3 presigned URL for the update file associated with the specified <code>JobId</code> value. The
     * software update will be available for 2 days after this request is made. To access an update after the 2 days
     * have passed, you'll have to make another call to <code>GetSoftwareUpdates</code>.
     * </p>
     * 
     * @return The Amazon S3 presigned URL for the update file associated with the specified <code>JobId</code> value.
     *         The software update will be available for 2 days after this request is made. To access an update after
     *         the 2 days have passed, you'll have to make another call to <code>GetSoftwareUpdates</code>.
     */
    public String updatesURI() {
        return updatesURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updatesURI());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSoftwareUpdatesResponse)) {
            return false;
        }
        GetSoftwareUpdatesResponse other = (GetSoftwareUpdatesResponse) obj;
        return Objects.equals(updatesURI(), other.updatesURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSoftwareUpdatesResponse").add("UpdatesURI", updatesURI()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdatesURI":
            return Optional.ofNullable(clazz.cast(updatesURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSoftwareUpdatesResponse, T> g) {
        return obj -> g.apply((GetSoftwareUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSoftwareUpdatesResponse> {
        /**
         * <p>
         * The Amazon S3 presigned URL for the update file associated with the specified <code>JobId</code> value. The
         * software update will be available for 2 days after this request is made. To access an update after the 2 days
         * have passed, you'll have to make another call to <code>GetSoftwareUpdates</code>.
         * </p>
         * 
         * @param updatesURI
         *        The Amazon S3 presigned URL for the update file associated with the specified <code>JobId</code>
         *        value. The software update will be available for 2 days after this request is made. To access an
         *        update after the 2 days have passed, you'll have to make another call to
         *        <code>GetSoftwareUpdates</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatesURI(String updatesURI);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String updatesURI;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSoftwareUpdatesResponse model) {
            super(model);
            updatesURI(model.updatesURI);
        }

        public final String getUpdatesURI() {
            return updatesURI;
        }

        @Override
        public final Builder updatesURI(String updatesURI) {
            this.updatesURI = updatesURI;
            return this;
        }

        public final void setUpdatesURI(String updatesURI) {
            this.updatesURI = updatesURI;
        }

        @Override
        public GetSoftwareUpdatesResponse build() {
            return new GetSoftwareUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
