/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeClusterResponse.Builder, DescribeClusterResponse> {
    private static final SdkField<ClusterMetadata> CLUSTER_METADATA_FIELD = SdkField
            .<ClusterMetadata> builder(MarshallingType.SDK_POJO).getter(getter(DescribeClusterResponse::clusterMetadata))
            .setter(setter(Builder::clusterMetadata)).constructor(ClusterMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_METADATA_FIELD));

    private final ClusterMetadata clusterMetadata;

    private DescribeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterMetadata = builder.clusterMetadata;
    }

    /**
     * <p>
     * Information about a specific cluster, including shipping information, cluster status, and other important
     * metadata.
     * </p>
     * 
     * @return Information about a specific cluster, including shipping information, cluster status, and other important
     *         metadata.
     */
    public ClusterMetadata clusterMetadata() {
        return clusterMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse) obj;
        return Objects.equals(clusterMetadata(), other.clusterMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClusterResponse").add("ClusterMetadata", clusterMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterMetadata":
            return Optional.ofNullable(clazz.cast(clusterMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterResponse, T> g) {
        return obj -> g.apply((DescribeClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterResponse> {
        /**
         * <p>
         * Information about a specific cluster, including shipping information, cluster status, and other important
         * metadata.
         * </p>
         * 
         * @param clusterMetadata
         *        Information about a specific cluster, including shipping information, cluster status, and other
         *        important metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterMetadata(ClusterMetadata clusterMetadata);

        /**
         * <p>
         * Information about a specific cluster, including shipping information, cluster status, and other important
         * metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link ClusterMetadata.Builder} avoiding the need to
         * create one manually via {@link ClusterMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterMetadata(ClusterMetadata)}.
         * 
         * @param clusterMetadata
         *        a consumer that will call methods on {@link ClusterMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterMetadata(ClusterMetadata)
         */
        default Builder clusterMetadata(Consumer<ClusterMetadata.Builder> clusterMetadata) {
            return clusterMetadata(ClusterMetadata.builder().applyMutation(clusterMetadata).build());
        }
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private ClusterMetadata clusterMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            super(model);
            clusterMetadata(model.clusterMetadata);
        }

        public final ClusterMetadata.Builder getClusterMetadata() {
            return clusterMetadata != null ? clusterMetadata.toBuilder() : null;
        }

        @Override
        public final Builder clusterMetadata(ClusterMetadata clusterMetadata) {
            this.clusterMetadata = clusterMetadata;
            return this;
        }

        public final void setClusterMetadata(ClusterMetadata.BuilderImpl clusterMetadata) {
            this.clusterMetadata = clusterMetadata != null ? clusterMetadata.build() : null;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
