/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the real-time status of a Snowball's data transfer while the device is at AWS. This data is only available
 * while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTransfer implements SdkPojo, Serializable, ToCopyableBuilder<DataTransfer.Builder, DataTransfer> {
    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransfer::bytesTransferred)).setter(setter(Builder::bytesTransferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()).build();

    private static final SdkField<Long> OBJECTS_TRANSFERRED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransfer::objectsTransferred)).setter(setter(Builder::objectsTransferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectsTransferred").build())
            .build();

    private static final SdkField<Long> TOTAL_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransfer::totalBytes)).setter(setter(Builder::totalBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBytes").build()).build();

    private static final SdkField<Long> TOTAL_OBJECTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransfer::totalObjects)).setter(setter(Builder::totalObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalObjects").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_TRANSFERRED_FIELD,
            OBJECTS_TRANSFERRED_FIELD, TOTAL_BYTES_FIELD, TOTAL_OBJECTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long bytesTransferred;

    private final Long objectsTransferred;

    private final Long totalBytes;

    private final Long totalObjects;

    private DataTransfer(BuilderImpl builder) {
        this.bytesTransferred = builder.bytesTransferred;
        this.objectsTransferred = builder.objectsTransferred;
        this.totalBytes = builder.totalBytes;
        this.totalObjects = builder.totalObjects;
    }

    /**
     * <p>
     * The number of bytes transferred between a Snowball and Amazon S3.
     * </p>
     * 
     * @return The number of bytes transferred between a Snowball and Amazon S3.
     */
    public Long bytesTransferred() {
        return bytesTransferred;
    }

    /**
     * <p>
     * The number of objects transferred between a Snowball and Amazon S3.
     * </p>
     * 
     * @return The number of objects transferred between a Snowball and Amazon S3.
     */
    public Long objectsTransferred() {
        return objectsTransferred;
    }

    /**
     * <p>
     * The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until all
     * the keys that will be transferred have been listed.
     * </p>
     * 
     * @return The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero)
     *         until all the keys that will be transferred have been listed.
     */
    public Long totalBytes() {
        return totalBytes;
    }

    /**
     * <p>
     * The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until
     * all the keys that will be transferred have been listed.
     * </p>
     * 
     * @return The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0
     *         (zero) until all the keys that will be transferred have been listed.
     */
    public Long totalObjects() {
        return totalObjects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(objectsTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(totalBytes());
        hashCode = 31 * hashCode + Objects.hashCode(totalObjects());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransfer)) {
            return false;
        }
        DataTransfer other = (DataTransfer) obj;
        return Objects.equals(bytesTransferred(), other.bytesTransferred())
                && Objects.equals(objectsTransferred(), other.objectsTransferred())
                && Objects.equals(totalBytes(), other.totalBytes()) && Objects.equals(totalObjects(), other.totalObjects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataTransfer").add("BytesTransferred", bytesTransferred())
                .add("ObjectsTransferred", objectsTransferred()).add("TotalBytes", totalBytes())
                .add("TotalObjects", totalObjects()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BytesTransferred":
            return Optional.ofNullable(clazz.cast(bytesTransferred()));
        case "ObjectsTransferred":
            return Optional.ofNullable(clazz.cast(objectsTransferred()));
        case "TotalBytes":
            return Optional.ofNullable(clazz.cast(totalBytes()));
        case "TotalObjects":
            return Optional.ofNullable(clazz.cast(totalObjects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataTransfer, T> g) {
        return obj -> g.apply((DataTransfer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTransfer> {
        /**
         * <p>
         * The number of bytes transferred between a Snowball and Amazon S3.
         * </p>
         * 
         * @param bytesTransferred
         *        The number of bytes transferred between a Snowball and Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesTransferred(Long bytesTransferred);

        /**
         * <p>
         * The number of objects transferred between a Snowball and Amazon S3.
         * </p>
         * 
         * @param objectsTransferred
         *        The number of objects transferred between a Snowball and Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectsTransferred(Long objectsTransferred);

        /**
         * <p>
         * The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until
         * all the keys that will be transferred have been listed.
         * </p>
         * 
         * @param totalBytes
         *        The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero)
         *        until all the keys that will be transferred have been listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBytes(Long totalBytes);

        /**
         * <p>
         * The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero)
         * until all the keys that will be transferred have been listed.
         * </p>
         * 
         * @param totalObjects
         *        The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0
         *        (zero) until all the keys that will be transferred have been listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalObjects(Long totalObjects);
    }

    static final class BuilderImpl implements Builder {
        private Long bytesTransferred;

        private Long objectsTransferred;

        private Long totalBytes;

        private Long totalObjects;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransfer model) {
            bytesTransferred(model.bytesTransferred);
            objectsTransferred(model.objectsTransferred);
            totalBytes(model.totalBytes);
            totalObjects(model.totalObjects);
        }

        public final Long getBytesTransferred() {
            return bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        public final Long getObjectsTransferred() {
            return objectsTransferred;
        }

        @Override
        public final Builder objectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
            return this;
        }

        public final void setObjectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
        }

        public final Long getTotalBytes() {
            return totalBytes;
        }

        @Override
        public final Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public final void setTotalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
        }

        public final Long getTotalObjects() {
            return totalObjects;
        }

        @Override
        public final Builder totalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
            return this;
        }

        public final void setTotalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
        }

        @Override
        public DataTransfer build() {
            return new DataTransfer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
