/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobManifestResponse extends SnowballResponse implements
        ToCopyableBuilder<GetJobManifestResponse.Builder, GetJobManifestResponse> {
    private static final SdkField<String> MANIFEST_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestURI").getter(getter(GetJobManifestResponse::manifestURI)).setter(setter(Builder::manifestURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestURI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_URI_FIELD));

    private final String manifestURI;

    private GetJobManifestResponse(BuilderImpl builder) {
        super(builder);
        this.manifestURI = builder.manifestURI;
    }

    /**
     * <p>
     * The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.
     * </p>
     * 
     * @return The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.
     */
    public String manifestURI() {
        return manifestURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(manifestURI());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobManifestResponse)) {
            return false;
        }
        GetJobManifestResponse other = (GetJobManifestResponse) obj;
        return Objects.equals(manifestURI(), other.manifestURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetJobManifestResponse").add("ManifestURI", manifestURI()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestURI":
            return Optional.ofNullable(clazz.cast(manifestURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobManifestResponse, T> g) {
        return obj -> g.apply((GetJobManifestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobManifestResponse> {
        /**
         * <p>
         * The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.
         * </p>
         * 
         * @param manifestURI
         *        The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestURI(String manifestURI);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String manifestURI;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobManifestResponse model) {
            super(model);
            manifestURI(model.manifestURI);
        }

        public final String getManifestURI() {
            return manifestURI;
        }

        @Override
        public final Builder manifestURI(String manifestURI) {
            this.manifestURI = manifestURI;
            return this;
        }

        public final void setManifestURI(String manifestURI) {
            this.manifestURI = manifestURI;
        }

        @Override
        public GetJobManifestResponse build() {
            return new GetJobManifestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
