/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinition;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaResource> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaArn").getter(LambdaResource.getter(LambdaResource::lambdaArn)).setter(LambdaResource.setter(Builder::lambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaArn").build()}).build();
    private static final SdkField<List<EventTriggerDefinition>> EVENT_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTriggers").getter(LambdaResource.getter(LambdaResource::eventTriggers)).setter(LambdaResource.setter(Builder::eventTriggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTriggerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD, EVENT_TRIGGERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lambdaArn;
    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    public String lambdaArn() {
        return this.lambdaArn;
    }

    public boolean hasEventTriggers() {
        return this.eventTriggers != null && !(this.eventTriggers instanceof SdkAutoConstructList);
    }

    public List<EventTriggerDefinition> eventTriggers() {
        return this.eventTriggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTriggers() ? this.eventTriggers() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource)obj;
        return Objects.equals(this.lambdaArn(), other.lambdaArn()) && this.hasEventTriggers() == other.hasEventTriggers() && Objects.equals(this.eventTriggers(), other.eventTriggers());
    }

    public String toString() {
        return ToString.builder((String)"LambdaResource").add("LambdaArn", (Object)this.lambdaArn()).add("EventTriggers", this.hasEventTriggers() ? this.eventTriggers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaArn()));
            }
            case "EventTriggers": {
                return Optional.ofNullable(clazz.cast(this.eventTriggers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaResource, T> g) {
        return obj -> g.apply((LambdaResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaArn;
        private List<EventTriggerDefinition> eventTriggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            this.lambdaArn(model.lambdaArn);
            this.eventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        public final Collection<EventTriggerDefinition.Builder> getEventTriggers() {
            if (this.eventTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTriggers != null ? (Collection)this.eventTriggers.stream().map(EventTriggerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition ... eventTriggers) {
            this.eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(Consumer<EventTriggerDefinition.Builder> ... eventTriggers) {
            this.eventTriggers(Stream.of(eventTriggers).map(c -> (EventTriggerDefinition)((EventTriggerDefinition.Builder)EventTriggerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition.BuilderImpl> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copyFromBuilder(eventTriggers);
        }

        public LambdaResource build() {
            return new LambdaResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaResource> {
        public Builder lambdaArn(String var1);

        public Builder eventTriggers(Collection<EventTriggerDefinition> var1);

        public Builder eventTriggers(EventTriggerDefinition ... var1);

        public Builder eventTriggers(Consumer<EventTriggerDefinition.Builder> ... var1);
    }
}

