/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax documents required in your AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxDocuments implements SdkPojo, Serializable, ToCopyableBuilder<TaxDocuments.Builder, TaxDocuments> {
    private static final SdkField<INDTaxDocuments> IND_FIELD = SdkField.<INDTaxDocuments> builder(MarshallingType.SDK_POJO)
            .memberName("IND").getter(getter(TaxDocuments::ind)).setter(setter(Builder::ind))
            .constructor(INDTaxDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IND").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IND_FIELD));

    private static final long serialVersionUID = 1L;

    private final INDTaxDocuments ind;

    private TaxDocuments(BuilderImpl builder) {
        this.ind = builder.ind;
    }

    /**
     * Returns the value of the IND property for this object.
     * 
     * @return The value of the IND property for this object.
     */
    public INDTaxDocuments ind() {
        return ind;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ind());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxDocuments)) {
            return false;
        }
        TaxDocuments other = (TaxDocuments) obj;
        return Objects.equals(ind(), other.ind());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TaxDocuments").add("IND", ind()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IND":
            return Optional.ofNullable(clazz.cast(ind()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaxDocuments, T> g) {
        return obj -> g.apply((TaxDocuments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxDocuments> {
        /**
         * Sets the value of the IND property for this object.
         *
         * @param ind
         *        The new value for the IND property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ind(INDTaxDocuments ind);

        /**
         * Sets the value of the IND property for this object.
         *
         * This is a convenience that creates an instance of the {@link INDTaxDocuments.Builder} avoiding the need to
         * create one manually via {@link INDTaxDocuments#builder()}.
         *
         * When the {@link Consumer} completes, {@link INDTaxDocuments.Builder#build()} is called immediately and its
         * result is passed to {@link #ind(INDTaxDocuments)}.
         * 
         * @param ind
         *        a consumer that will call methods on {@link INDTaxDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ind(INDTaxDocuments)
         */
        default Builder ind(Consumer<INDTaxDocuments.Builder> ind) {
            return ind(INDTaxDocuments.builder().applyMutation(ind).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private INDTaxDocuments ind;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxDocuments model) {
            ind(model.ind);
        }

        public final INDTaxDocuments.Builder getInd() {
            return ind != null ? ind.toBuilder() : null;
        }

        @Override
        public final Builder ind(INDTaxDocuments ind) {
            this.ind = ind;
            return this;
        }

        public final void setInd(INDTaxDocuments.BuilderImpl ind) {
            this.ind = ind != null ? ind.build() : null;
        }

        @Override
        public TaxDocuments build() {
            return new TaxDocuments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
