/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from
 * or imported into. For export jobs, this object can have an optional <code>KeyRange</code> value. The length of the
 * range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive
 * <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Resource implements SdkPojo, Serializable, ToCopyableBuilder<S3Resource.Builder, S3Resource> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketArn").getter(getter(S3Resource::bucketArn)).setter(setter(Builder::bucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketArn").build()).build();

    private static final SdkField<KeyRange> KEY_RANGE_FIELD = SdkField.<KeyRange> builder(MarshallingType.SDK_POJO)
            .memberName("KeyRange").getter(getter(S3Resource::keyRange)).setter(setter(Builder::keyRange))
            .constructor(KeyRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            KEY_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketArn;

    private final KeyRange keyRange;

    private S3Resource(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.keyRange = builder.keyRange;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon S3 bucket.
     */
    public String bucketArn() {
        return bucketArn;
    }

    /**
     * <p>
     * For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length
     * of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive
     * <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
     * </p>
     * 
     * @return For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket.
     *         The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>,
     *         an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
     */
    public KeyRange keyRange() {
        return keyRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Resource)) {
            return false;
        }
        S3Resource other = (S3Resource) obj;
        return Objects.equals(bucketArn(), other.bucketArn()) && Objects.equals(keyRange(), other.keyRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3Resource").add("BucketArn", bucketArn()).add("KeyRange", keyRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketArn":
            return Optional.ofNullable(clazz.cast(bucketArn()));
        case "KeyRange":
            return Optional.ofNullable(clazz.cast(keyRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Resource, T> g) {
        return obj -> g.apply((S3Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Resource> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket.
         * </p>
         * 
         * @param bucketArn
         *        The Amazon Resource Name (ARN) of an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketArn(String bucketArn);

        /**
         * <p>
         * For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The
         * length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an
         * inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * 
         * @param keyRange
         *        For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket.
         *        The length of the range is defined at job creation, and has either an inclusive
         *        <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary
         *        sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRange(KeyRange keyRange);

        /**
         * <p>
         * For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The
         * length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an
         * inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * This is a convenience that creates an instance of the {@link KeyRange.Builder} avoiding the need to create
         * one manually via {@link KeyRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyRange.Builder#build()} is called immediately and its result is
         * passed to {@link #keyRange(KeyRange)}.
         * 
         * @param keyRange
         *        a consumer that will call methods on {@link KeyRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyRange(KeyRange)
         */
        default Builder keyRange(Consumer<KeyRange.Builder> keyRange) {
            return keyRange(KeyRange.builder().applyMutation(keyRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketArn;

        private KeyRange keyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Resource model) {
            bucketArn(model.bucketArn);
            keyRange(model.keyRange);
        }

        public final String getBucketArn() {
            return bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        public final KeyRange.Builder getKeyRange() {
            return keyRange != null ? keyRange.toBuilder() : null;
        }

        @Override
        public final Builder keyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
            return this;
        }

        public final void setKeyRange(KeyRange.BuilderImpl keyRange) {
            this.keyRange = keyRange != null ? keyRange.build() : null;
        }

        @Override
        public S3Resource build() {
            return new S3Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
