/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.Shipment;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShippingDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShippingDetails> {
    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShippingOption").getter(ShippingDetails.getter(ShippingDetails::shippingOptionAsString)).setter(ShippingDetails.setter(Builder::shippingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()}).build();
    private static final SdkField<Shipment> INBOUND_SHIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InboundShipment").getter(ShippingDetails.getter(ShippingDetails::inboundShipment)).setter(ShippingDetails.setter(Builder::inboundShipment)).constructor(Shipment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundShipment").build()}).build();
    private static final SdkField<Shipment> OUTBOUND_SHIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutboundShipment").getter(ShippingDetails.getter(ShippingDetails::outboundShipment)).setter(ShippingDetails.setter(Builder::outboundShipment)).constructor(Shipment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundShipment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHIPPING_OPTION_FIELD, INBOUND_SHIPMENT_FIELD, OUTBOUND_SHIPMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shippingOption;
    private final Shipment inboundShipment;
    private final Shipment outboundShipment;

    private ShippingDetails(BuilderImpl builder) {
        this.shippingOption = builder.shippingOption;
        this.inboundShipment = builder.inboundShipment;
        this.outboundShipment = builder.outboundShipment;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionAsString() {
        return this.shippingOption;
    }

    public Shipment inboundShipment() {
        return this.inboundShipment;
    }

    public Shipment outboundShipment() {
        return this.outboundShipment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundShipment());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundShipment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShippingDetails)) {
            return false;
        }
        ShippingDetails other = (ShippingDetails)obj;
        return Objects.equals(this.shippingOptionAsString(), other.shippingOptionAsString()) && Objects.equals(this.inboundShipment(), other.inboundShipment()) && Objects.equals(this.outboundShipment(), other.outboundShipment());
    }

    public String toString() {
        return ToString.builder((String)"ShippingDetails").add("ShippingOption", (Object)this.shippingOptionAsString()).add("InboundShipment", (Object)this.inboundShipment()).add("OutboundShipment", (Object)this.outboundShipment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShippingOption": {
                return Optional.ofNullable(clazz.cast(this.shippingOptionAsString()));
            }
            case "InboundShipment": {
                return Optional.ofNullable(clazz.cast(this.inboundShipment()));
            }
            case "OutboundShipment": {
                return Optional.ofNullable(clazz.cast(this.outboundShipment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShippingDetails, T> g) {
        return obj -> g.apply((ShippingDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shippingOption;
        private Shipment inboundShipment;
        private Shipment outboundShipment;

        private BuilderImpl() {
        }

        private BuilderImpl(ShippingDetails model) {
            this.shippingOption(model.shippingOption);
            this.inboundShipment(model.inboundShipment);
            this.outboundShipment(model.outboundShipment);
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Shipment.Builder getInboundShipment() {
            return this.inboundShipment != null ? this.inboundShipment.toBuilder() : null;
        }

        @Override
        public final Builder inboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
            return this;
        }

        public final void setInboundShipment(Shipment.BuilderImpl inboundShipment) {
            this.inboundShipment = inboundShipment != null ? inboundShipment.build() : null;
        }

        public final Shipment.Builder getOutboundShipment() {
            return this.outboundShipment != null ? this.outboundShipment.toBuilder() : null;
        }

        @Override
        public final Builder outboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
            return this;
        }

        public final void setOutboundShipment(Shipment.BuilderImpl outboundShipment) {
            this.outboundShipment = outboundShipment != null ? outboundShipment.build() : null;
        }

        public ShippingDetails build() {
            return new ShippingDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShippingDetails> {
        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder inboundShipment(Shipment var1);

        default public Builder inboundShipment(Consumer<Shipment.Builder> inboundShipment) {
            return this.inboundShipment((Shipment)((Shipment.Builder)Shipment.builder().applyMutation(inboundShipment)).build());
        }

        public Builder outboundShipment(Shipment var1);

        default public Builder outboundShipment(Consumer<Shipment.Builder> outboundShipment) {
            return this.outboundShipment((Shipment)((Shipment.Builder)Shipment.builder().applyMutation(outboundShipment)).build());
        }
    }
}

