/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a specific job including shipping information, job status, and other important metadata.
 * This information is returned as a part of the response syntax of the <code>DescribeJob</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobMetadata implements SdkPojo, Serializable, ToCopyableBuilder<JobMetadata.Builder, JobMetadata> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(JobMetadata::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobState").getter(getter(JobMetadata::jobStateAsString)).setter(setter(Builder::jobState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobState").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(JobMetadata::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnowballType").getter(getter(JobMetadata::snowballTypeAsString)).setter(setter(Builder::snowballType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(JobMetadata::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.<JobResource> builder(MarshallingType.SDK_POJO)
            .memberName("Resources").getter(getter(JobMetadata::resources)).setter(setter(Builder::resources))
            .constructor(JobResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(JobMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyARN").getter(getter(JobMetadata::kmsKeyARN)).setter(setter(Builder::kmsKeyARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyARN").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(JobMetadata::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressId").getter(getter(JobMetadata::addressId)).setter(setter(Builder::addressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()).build();

    private static final SdkField<ShippingDetails> SHIPPING_DETAILS_FIELD = SdkField
            .<ShippingDetails> builder(MarshallingType.SDK_POJO).memberName("ShippingDetails")
            .getter(getter(JobMetadata::shippingDetails)).setter(setter(Builder::shippingDetails))
            .constructor(ShippingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingDetails").build()).build();

    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnowballCapacityPreference")
            .getter(getter(JobMetadata::snowballCapacityPreferenceAsString))
            .setter(setter(Builder::snowballCapacityPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build())
            .build();

    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.<Notification> builder(MarshallingType.SDK_POJO)
            .memberName("Notification").getter(getter(JobMetadata::notification)).setter(setter(Builder::notification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<DataTransfer> DATA_TRANSFER_PROGRESS_FIELD = SdkField
            .<DataTransfer> builder(MarshallingType.SDK_POJO).memberName("DataTransferProgress")
            .getter(getter(JobMetadata::dataTransferProgress)).setter(setter(Builder::dataTransferProgress))
            .constructor(DataTransfer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProgress").build())
            .build();

    private static final SdkField<JobLogs> JOB_LOG_INFO_FIELD = SdkField.<JobLogs> builder(MarshallingType.SDK_POJO)
            .memberName("JobLogInfo").getter(getter(JobMetadata::jobLogInfo)).setter(setter(Builder::jobLogInfo))
            .constructor(JobLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobLogInfo").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(JobMetadata::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForwardingAddressId").getter(getter(JobMetadata::forwardingAddressId))
            .setter(setter(Builder::forwardingAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build())
            .build();

    private static final SdkField<TaxDocuments> TAX_DOCUMENTS_FIELD = SdkField.<TaxDocuments> builder(MarshallingType.SDK_POJO)
            .memberName("TaxDocuments").getter(getter(JobMetadata::taxDocuments)).setter(setter(Builder::taxDocuments))
            .constructor(TaxDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxDocuments").build()).build();

    private static final SdkField<DeviceConfiguration> DEVICE_CONFIGURATION_FIELD = SdkField
            .<DeviceConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeviceConfiguration")
            .getter(getter(JobMetadata::deviceConfiguration)).setter(setter(Builder::deviceConfiguration))
            .constructor(DeviceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_STATE_FIELD,
            JOB_TYPE_FIELD, SNOWBALL_TYPE_FIELD, CREATION_DATE_FIELD, RESOURCES_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD,
            ROLE_ARN_FIELD, ADDRESS_ID_FIELD, SHIPPING_DETAILS_FIELD, SNOWBALL_CAPACITY_PREFERENCE_FIELD, NOTIFICATION_FIELD,
            DATA_TRANSFER_PROGRESS_FIELD, JOB_LOG_INFO_FIELD, CLUSTER_ID_FIELD, FORWARDING_ADDRESS_ID_FIELD, TAX_DOCUMENTS_FIELD,
            DEVICE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobState;

    private final String jobType;

    private final String snowballType;

    private final Instant creationDate;

    private final JobResource resources;

    private final String description;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String addressId;

    private final ShippingDetails shippingDetails;

    private final String snowballCapacityPreference;

    private final Notification notification;

    private final DataTransfer dataTransferProgress;

    private final JobLogs jobLogInfo;

    private final String clusterId;

    private final String forwardingAddressId;

    private final TaxDocuments taxDocuments;

    private final DeviceConfiguration deviceConfiguration;

    private JobMetadata(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.resources = builder.resources;
        this.description = builder.description;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.addressId = builder.addressId;
        this.shippingDetails = builder.shippingDetails;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.notification = builder.notification;
        this.dataTransferProgress = builder.dataTransferProgress;
        this.jobLogInfo = builder.jobLogInfo;
        this.clusterId = builder.clusterId;
        this.forwardingAddressId = builder.forwardingAddressId;
        this.taxDocuments = builder.taxDocuments;
        this.deviceConfiguration = builder.deviceConfiguration;
    }

    /**
     * <p>
     * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The automatically generated ID for a job, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status of the jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobState} will
     * return {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStateAsString}.
     * </p>
     * 
     * @return The current status of the jobs.
     * @see JobState
     */
    public JobState jobState() {
        return JobState.fromValue(jobState);
    }

    /**
     * <p>
     * The current status of the jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobState} will
     * return {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStateAsString}.
     * </p>
     * 
     * @return The current status of the jobs.
     * @see JobState
     */
    public String jobStateAsString() {
        return jobState;
    }

    /**
     * <p>
     * The type of job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of job.
     * @see JobType
     */
    public JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type of job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of job.
     * @see JobType
     */
    public String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The type of device used with this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of device used with this job.
     * @see SnowballType
     */
    public SnowballType snowballType() {
        return SnowballType.fromValue(snowballType);
    }

    /**
     * <p>
     * The type of device used with this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of device used with this job.
     * @see SnowballType
     */
    public String snowballTypeAsString() {
        return snowballType;
    }

    /**
     * <p>
     * The creation date for this job.
     * </p>
     * 
     * @return The creation date for this job.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket
     * that your transferred data will be exported from or imported into.
     * </p>
     * 
     * @return An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3
     *         bucket that your transferred data will be exported from or imported into.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * The description of the job, provided at job creation.
     * </p>
     * 
     * @return The description of the job, provided at job creation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job. This
     * ARN was created using the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS
     * KMS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job.
     *         This ARN was created using the <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     *         AWS KMS.
     */
    public String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The role ARN associated with this job. This ARN was created using the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS
     * Identity and Access Management (IAM).
     * </p>
     * 
     * @return The role ARN associated with this job. This ARN was created using the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *         in AWS Identity and Access Management (IAM).
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ID for the address that you want the Snowball shipped to.
     * </p>
     * 
     * @return The ID for the address that you want the Snowball shipped to.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
     * </p>
     * 
     * @return A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
     */
    public ShippingDetails shippingDetails() {
        return shippingDetails;
    }

    /**
     * <p>
     * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose between
     * 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
     *         between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     * @see SnowballCapacity
     */
    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(snowballCapacityPreference);
    }

    /**
     * <p>
     * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose between
     * 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
     *         between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     * @see SnowballCapacity
     */
    public String snowballCapacityPreferenceAsString() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The
     * <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code>
     * action in the <code>JobMetadata</code> data type.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job.
     *         The <code>Notification</code> object is returned as a part of the response syntax of the
     *         <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * A value that defines the real-time status of a Snowball's data transfer while the device is at AWS. This data is
     * only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and
     * export jobs.
     * </p>
     * 
     * @return A value that defines the real-time status of a Snowball's data transfer while the device is at AWS. This
     *         data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both
     *         import and export jobs.
     */
    public DataTransfer dataTransferProgress() {
        return dataTransferProgress;
    }

    /**
     * <p>
     * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes
     * available at the end of the import process. For export jobs, your job report typically becomes available while
     * the Snowball for your job part is being delivered to you.
     * </p>
     * 
     * @return Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report
     *         becomes available at the end of the import process. For export jobs, your job report typically becomes
     *         available while the Snowball for your job part is being delivered to you.
     */
    public JobLogs jobLogInfo() {
        return jobLogInfo;
    }

    /**
     * <p>
     * The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field
     * is not supported in most regions.
     * </p>
     * 
     * @return The ID of the address that you want a job shipped to, after it will be shipped to its primary address.
     *         This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    /**
     * <p>
     * The metadata associated with the tax documents required in your AWS Region.
     * </p>
     * 
     * @return The metadata associated with the tax documents required in your AWS Region.
     */
    public TaxDocuments taxDocuments() {
        return taxDocuments;
    }

    /**
     * Returns the value of the DeviceConfiguration property for this object.
     * 
     * @return The value of the DeviceConfiguration property for this object.
     */
    public DeviceConfiguration deviceConfiguration() {
        return deviceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(shippingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferProgress());
        hashCode = 31 * hashCode + Objects.hashCode(jobLogInfo());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(taxDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMetadata)) {
            return false;
        }
        JobMetadata other = (JobMetadata) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobStateAsString(), other.jobStateAsString())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(snowballTypeAsString(), other.snowballTypeAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(resources(), other.resources())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyARN(), other.kmsKeyARN())
                && Objects.equals(roleARN(), other.roleARN()) && Objects.equals(addressId(), other.addressId())
                && Objects.equals(shippingDetails(), other.shippingDetails())
                && Objects.equals(snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString())
                && Objects.equals(notification(), other.notification())
                && Objects.equals(dataTransferProgress(), other.dataTransferProgress())
                && Objects.equals(jobLogInfo(), other.jobLogInfo()) && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(forwardingAddressId(), other.forwardingAddressId())
                && Objects.equals(taxDocuments(), other.taxDocuments())
                && Objects.equals(deviceConfiguration(), other.deviceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobMetadata").add("JobId", jobId()).add("JobState", jobStateAsString())
                .add("JobType", jobTypeAsString()).add("SnowballType", snowballTypeAsString())
                .add("CreationDate", creationDate()).add("Resources", resources()).add("Description", description())
                .add("KmsKeyARN", kmsKeyARN()).add("RoleARN", roleARN()).add("AddressId", addressId())
                .add("ShippingDetails", shippingDetails())
                .add("SnowballCapacityPreference", snowballCapacityPreferenceAsString()).add("Notification", notification())
                .add("DataTransferProgress", dataTransferProgress()).add("JobLogInfo", jobLogInfo())
                .add("ClusterId", clusterId()).add("ForwardingAddressId", forwardingAddressId())
                .add("TaxDocuments", taxDocuments()).add("DeviceConfiguration", deviceConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobState":
            return Optional.ofNullable(clazz.cast(jobStateAsString()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "SnowballType":
            return Optional.ofNullable(clazz.cast(snowballTypeAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyARN":
            return Optional.ofNullable(clazz.cast(kmsKeyARN()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "AddressId":
            return Optional.ofNullable(clazz.cast(addressId()));
        case "ShippingDetails":
            return Optional.ofNullable(clazz.cast(shippingDetails()));
        case "SnowballCapacityPreference":
            return Optional.ofNullable(clazz.cast(snowballCapacityPreferenceAsString()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "DataTransferProgress":
            return Optional.ofNullable(clazz.cast(dataTransferProgress()));
        case "JobLogInfo":
            return Optional.ofNullable(clazz.cast(jobLogInfo()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "ForwardingAddressId":
            return Optional.ofNullable(clazz.cast(forwardingAddressId()));
        case "TaxDocuments":
            return Optional.ofNullable(clazz.cast(taxDocuments()));
        case "DeviceConfiguration":
            return Optional.ofNullable(clazz.cast(deviceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobMetadata, T> g) {
        return obj -> g.apply((JobMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobMetadata> {
        /**
         * <p>
         * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The automatically generated ID for a job, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status of the jobs.
         * </p>
         * 
         * @param jobState
         *        The current status of the jobs.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(String jobState);

        /**
         * <p>
         * The current status of the jobs.
         * </p>
         * 
         * @param jobState
         *        The current status of the jobs.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(JobState jobState);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The type of device used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of device used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of device used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of device used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The creation date for this job.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3
         * bucket that your transferred data will be exported from or imported into.
         * </p>
         * 
         * @param resources
         *        An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon
         *        S3 bucket that your transferred data will be exported from or imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3
         * bucket that your transferred data will be exported from or imported into.
         * </p>
         * This is a convenience that creates an instance of the {@link JobResource.Builder} avoiding the need to create
         * one manually via {@link JobResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobResource.Builder#build()} is called immediately and its result
         * is passed to {@link #resources(JobResource)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link JobResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(JobResource)
         */
        default Builder resources(Consumer<JobResource.Builder> resources) {
            return resources(JobResource.builder().applyMutation(resources).build());
        }

        /**
         * <p>
         * The description of the job, provided at job creation.
         * </p>
         * 
         * @param description
         *        The description of the job, provided at job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job.
         * This ARN was created using the <a
         * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS
         * KMS.
         * </p>
         * 
         * @param kmsKeyARN
         *        The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this
         *        job. This ARN was created using the <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action
         *        in AWS KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The role ARN associated with this job. This ARN was created using the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in
         * AWS Identity and Access Management (IAM).
         * </p>
         * 
         * @param roleARN
         *        The role ARN associated with this job. This ARN was created using the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
         *        action in AWS Identity and Access Management (IAM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ID for the address that you want the Snowball shipped to.
         * </p>
         * 
         * @param addressId
         *        The ID for the address that you want the Snowball shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
         * </p>
         * 
         * @param shippingDetails
         *        A job's shipping information, including inbound and outbound tracking numbers and shipping speed
         *        options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingDetails(ShippingDetails shippingDetails);

        /**
         * <p>
         * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
         * </p>
         * This is a convenience that creates an instance of the {@link ShippingDetails.Builder} avoiding the need to
         * create one manually via {@link ShippingDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ShippingDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #shippingDetails(ShippingDetails)}.
         * 
         * @param shippingDetails
         *        a consumer that will call methods on {@link ShippingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingDetails(ShippingDetails)
         */
        default Builder shippingDetails(Consumer<ShippingDetails.Builder> shippingDetails) {
            return shippingDetails(ShippingDetails.builder().applyMutation(shippingDetails).build());
        }

        /**
         * <p>
         * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
         * between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The Snowball capacity preference for this job, specified at job creation. In US regions, you can
         *        choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
         * between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The Snowball capacity preference for this job, specified at job creation. In US regions, you can
         *        choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The
         * <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code>
         * action in the <code>JobMetadata</code> data type.
         * </p>
         * 
         * @param notification
         *        The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific
         *        job. The <code>Notification</code> object is returned as a part of the response syntax of the
         *        <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The
         * <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code>
         * action in the <code>JobMetadata</code> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * A value that defines the real-time status of a Snowball's data transfer while the device is at AWS. This data
         * is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import
         * and export jobs.
         * </p>
         * 
         * @param dataTransferProgress
         *        A value that defines the real-time status of a Snowball's data transfer while the device is at AWS.
         *        This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>,
         *        for both import and export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferProgress(DataTransfer dataTransferProgress);

        /**
         * <p>
         * A value that defines the real-time status of a Snowball's data transfer while the device is at AWS. This data
         * is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import
         * and export jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link DataTransfer.Builder} avoiding the need to
         * create one manually via {@link DataTransfer#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataTransfer.Builder#build()} is called immediately and its
         * result is passed to {@link #dataTransferProgress(DataTransfer)}.
         * 
         * @param dataTransferProgress
         *        a consumer that will call methods on {@link DataTransfer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataTransferProgress(DataTransfer)
         */
        default Builder dataTransferProgress(Consumer<DataTransfer.Builder> dataTransferProgress) {
            return dataTransferProgress(DataTransfer.builder().applyMutation(dataTransferProgress).build());
        }

        /**
         * <p>
         * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes
         * available at the end of the import process. For export jobs, your job report typically becomes available
         * while the Snowball for your job part is being delivered to you.
         * </p>
         * 
         * @param jobLogInfo
         *        Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report
         *        becomes available at the end of the import process. For export jobs, your job report typically becomes
         *        available while the Snowball for your job part is being delivered to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobLogInfo(JobLogs jobLogInfo);

        /**
         * <p>
         * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes
         * available at the end of the import process. For export jobs, your job report typically becomes available
         * while the Snowball for your job part is being delivered to you.
         * </p>
         * This is a convenience that creates an instance of the {@link JobLogs.Builder} avoiding the need to create one
         * manually via {@link JobLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobLogs.Builder#build()} is called immediately and its result is
         * passed to {@link #jobLogInfo(JobLogs)}.
         * 
         * @param jobLogInfo
         *        a consumer that will call methods on {@link JobLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobLogInfo(JobLogs)
         */
        default Builder jobLogInfo(Consumer<JobLogs.Builder> jobLogInfo) {
            return jobLogInfo(JobLogs.builder().applyMutation(jobLogInfo).build());
        }

        /**
         * <p>
         * The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param clusterId
         *        The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This
         * field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The ID of the address that you want a job shipped to, after it will be shipped to its primary address.
         *        This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);

        /**
         * <p>
         * The metadata associated with the tax documents required in your AWS Region.
         * </p>
         * 
         * @param taxDocuments
         *        The metadata associated with the tax documents required in your AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocuments(TaxDocuments taxDocuments);

        /**
         * <p>
         * The metadata associated with the tax documents required in your AWS Region.
         * </p>
         * This is a convenience that creates an instance of the {@link TaxDocuments.Builder} avoiding the need to
         * create one manually via {@link TaxDocuments#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaxDocuments.Builder#build()} is called immediately and its
         * result is passed to {@link #taxDocuments(TaxDocuments)}.
         * 
         * @param taxDocuments
         *        a consumer that will call methods on {@link TaxDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxDocuments(TaxDocuments)
         */
        default Builder taxDocuments(Consumer<TaxDocuments.Builder> taxDocuments) {
            return taxDocuments(TaxDocuments.builder().applyMutation(taxDocuments).build());
        }

        /**
         * Sets the value of the DeviceConfiguration property for this object.
         *
         * @param deviceConfiguration
         *        The new value for the DeviceConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfiguration(DeviceConfiguration deviceConfiguration);

        /**
         * Sets the value of the DeviceConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link DeviceConfiguration.Builder} avoiding the need
         * to create one manually via {@link DeviceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceConfiguration(DeviceConfiguration)}.
         * 
         * @param deviceConfiguration
         *        a consumer that will call methods on {@link DeviceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfiguration(DeviceConfiguration)
         */
        default Builder deviceConfiguration(Consumer<DeviceConfiguration.Builder> deviceConfiguration) {
            return deviceConfiguration(DeviceConfiguration.builder().applyMutation(deviceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobState;

        private String jobType;

        private String snowballType;

        private Instant creationDate;

        private JobResource resources;

        private String description;

        private String kmsKeyARN;

        private String roleARN;

        private String addressId;

        private ShippingDetails shippingDetails;

        private String snowballCapacityPreference;

        private Notification notification;

        private DataTransfer dataTransferProgress;

        private JobLogs jobLogInfo;

        private String clusterId;

        private String forwardingAddressId;

        private TaxDocuments taxDocuments;

        private DeviceConfiguration deviceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(JobMetadata model) {
            jobId(model.jobId);
            jobState(model.jobState);
            jobType(model.jobType);
            snowballType(model.snowballType);
            creationDate(model.creationDate);
            resources(model.resources);
            description(model.description);
            kmsKeyARN(model.kmsKeyARN);
            roleARN(model.roleARN);
            addressId(model.addressId);
            shippingDetails(model.shippingDetails);
            snowballCapacityPreference(model.snowballCapacityPreference);
            notification(model.notification);
            dataTransferProgress(model.dataTransferProgress);
            jobLogInfo(model.jobLogInfo);
            clusterId(model.clusterId);
            forwardingAddressId(model.forwardingAddressId);
            taxDocuments(model.taxDocuments);
            deviceConfiguration(model.deviceConfiguration);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobState() {
            return jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState == null ? null : jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final JobResource.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final ShippingDetails.Builder getShippingDetails() {
            return shippingDetails != null ? shippingDetails.toBuilder() : null;
        }

        @Override
        public final Builder shippingDetails(ShippingDetails shippingDetails) {
            this.shippingDetails = shippingDetails;
            return this;
        }

        public final void setShippingDetails(ShippingDetails.BuilderImpl shippingDetails) {
            this.shippingDetails = shippingDetails != null ? shippingDetails.build() : null;
        }

        public final String getSnowballCapacityPreference() {
            return snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference == null ? null : snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final DataTransfer.Builder getDataTransferProgress() {
            return dataTransferProgress != null ? dataTransferProgress.toBuilder() : null;
        }

        @Override
        public final Builder dataTransferProgress(DataTransfer dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
            return this;
        }

        public final void setDataTransferProgress(DataTransfer.BuilderImpl dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress != null ? dataTransferProgress.build() : null;
        }

        public final JobLogs.Builder getJobLogInfo() {
            return jobLogInfo != null ? jobLogInfo.toBuilder() : null;
        }

        @Override
        public final Builder jobLogInfo(JobLogs jobLogInfo) {
            this.jobLogInfo = jobLogInfo;
            return this;
        }

        public final void setJobLogInfo(JobLogs.BuilderImpl jobLogInfo) {
            this.jobLogInfo = jobLogInfo != null ? jobLogInfo.build() : null;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public final TaxDocuments.Builder getTaxDocuments() {
            return taxDocuments != null ? taxDocuments.toBuilder() : null;
        }

        @Override
        public final Builder taxDocuments(TaxDocuments taxDocuments) {
            this.taxDocuments = taxDocuments;
            return this;
        }

        public final void setTaxDocuments(TaxDocuments.BuilderImpl taxDocuments) {
            this.taxDocuments = taxDocuments != null ? taxDocuments.build() : null;
        }

        public final DeviceConfiguration.Builder getDeviceConfiguration() {
            return deviceConfiguration != null ? deviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfiguration deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final void setDeviceConfiguration(DeviceConfiguration.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        @Override
        public JobMetadata build() {
            return new JobMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
