/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, UpdateJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(UpdateJobRequest.getter(UpdateJobRequest::jobId)).setter(UpdateJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(UpdateJobRequest.getter(UpdateJobRequest::roleARN)).setter(UpdateJobRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notification").getter(UpdateJobRequest.getter(UpdateJobRequest::notification)).setter(UpdateJobRequest.setter(Builder::notification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resources").getter(UpdateJobRequest.getter(UpdateJobRequest::resources)).setter(UpdateJobRequest.setter(Builder::resources)).constructor(JobResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()}).build();
    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressId").getter(UpdateJobRequest.getter(UpdateJobRequest::addressId)).setter(UpdateJobRequest.setter(Builder::addressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()}).build();
    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShippingOption").getter(UpdateJobRequest.getter(UpdateJobRequest::shippingOptionAsString)).setter(UpdateJobRequest.setter(Builder::shippingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateJobRequest.getter(UpdateJobRequest::description)).setter(UpdateJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballCapacityPreference").getter(UpdateJobRequest.getter(UpdateJobRequest::snowballCapacityPreferenceAsString)).setter(UpdateJobRequest.setter(Builder::snowballCapacityPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build()}).build();
    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForwardingAddressId").getter(UpdateJobRequest.getter(UpdateJobRequest::forwardingAddressId)).setter(UpdateJobRequest.setter(Builder::forwardingAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, ROLE_ARN_FIELD, NOTIFICATION_FIELD, RESOURCES_FIELD, ADDRESS_ID_FIELD, SHIPPING_OPTION_FIELD, DESCRIPTION_FIELD, SNOWBALL_CAPACITY_PREFERENCE_FIELD, FORWARDING_ADDRESS_ID_FIELD));
    private final String jobId;
    private final String roleARN;
    private final Notification notification;
    private final JobResource resources;
    private final String addressId;
    private final String shippingOption;
    private final String description;
    private final String snowballCapacityPreference;
    private final String forwardingAddressId;

    private UpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.roleARN = builder.roleARN;
        this.notification = builder.notification;
        this.resources = builder.resources;
        this.addressId = builder.addressId;
        this.shippingOption = builder.shippingOption;
        this.description = builder.description;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public String jobId() {
        return this.jobId;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Notification notification() {
        return this.notification;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String addressId() {
        return this.addressId;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionAsString() {
        return this.shippingOption;
    }

    public String description() {
        return this.description;
    }

    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(this.snowballCapacityPreference);
    }

    public String snowballCapacityPreferenceAsString() {
        return this.snowballCapacityPreference;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.shippingOptionAsString(), other.shippingOptionAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateJobRequest").add("JobId", (Object)this.jobId()).add("RoleARN", (Object)this.roleARN()).add("Notification", (Object)this.notification()).add("Resources", (Object)this.resources()).add("AddressId", (Object)this.addressId()).add("ShippingOption", (Object)this.shippingOptionAsString()).add("Description", (Object)this.description()).add("SnowballCapacityPreference", (Object)this.snowballCapacityPreferenceAsString()).add("ForwardingAddressId", (Object)this.forwardingAddressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
            case "ShippingOption": {
                return Optional.ofNullable(clazz.cast(this.shippingOptionAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SnowballCapacityPreference": {
                return Optional.ofNullable(clazz.cast(this.snowballCapacityPreferenceAsString()));
            }
            case "ForwardingAddressId": {
                return Optional.ofNullable(clazz.cast(this.forwardingAddressId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobRequest, T> g) {
        return obj -> g.apply((UpdateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String roleARN;
        private Notification notification;
        private JobResource resources;
        private String addressId;
        private String shippingOption;
        private String description;
        private String snowballCapacityPreference;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.roleARN(model.roleARN);
            this.notification(model.notification);
            this.resources(model.resources);
            this.addressId(model.addressId);
            this.shippingOption(model.shippingOption);
            this.description(model.description);
            this.snowballCapacityPreference(model.snowballCapacityPreference);
            this.forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSnowballCapacityPreference() {
            return this.snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference == null ? null : snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobRequest> {
        public Builder jobId(String var1);

        public Builder roleARN(String var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().applyMutation(resources)).build());
        }

        public Builder addressId(String var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder description(String var1);

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder forwardingAddressId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

