/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddressesResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeAddressesResponse.Builder, DescribeAddressesResponse> {
    private static final SdkField<List<Address>> ADDRESSES_FIELD = SdkField
            .<List<Address>> builder(MarshallingType.LIST)
            .memberName("Addresses")
            .getter(getter(DescribeAddressesResponse::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAddressesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESSES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Address> addresses;

    private final String nextToken;

    private DescribeAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.addresses = builder.addresses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Addresses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Snow device shipping addresses that were created for this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Snow device shipping addresses that were created for this account.
     */
    public List<Address> addresses() {
        return addresses;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in
     *         the array.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addresses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse) obj;
        return Objects.equals(addresses(), other.addresses()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAddressesResponse").add("Addresses", addresses()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressesResponse, T> g) {
        return obj -> g.apply((DescribeAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddressesResponse> {
        /**
         * <p>
         * The Snow device shipping addresses that were created for this account.
         * </p>
         * 
         * @param addresses
         *        The Snow device shipping addresses that were created for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<Address> addresses);

        /**
         * <p>
         * The Snow device shipping addresses that were created for this account.
         * </p>
         * 
         * @param addresses
         *        The Snow device shipping addresses that were created for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Address... addresses);

        /**
         * <p>
         * The Snow device shipping addresses that were created for this account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Address>.Builder} avoiding the need to
         * create one manually via {@link List<Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Address>.Builder#build()} is called immediately and its
         * result is passed to {@link #addresses(List<Address>)}.
         * 
         * @param addresses
         *        a consumer that will call methods on {@link List<Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addresses(List<Address>)
         */
        Builder addresses(Consumer<Address.Builder>... addresses);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>DescribeAddresses</code> call, your list of returned addresses will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<Address> addresses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            super(model);
            addresses(model.addresses);
            nextToken(model.nextToken);
        }

        public final Collection<Address.Builder> getAddresses() {
            return addresses != null ? addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Consumer<Address.Builder>... addresses) {
            addresses(Stream.of(addresses).map(c -> Address.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
