/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The address that you want the Snow device(s) associated with a specific job to be shipped to. Addresses are validated
 * at the time of creation. The address you provide must be located within the serviceable area of your region. Although
 * no individual elements of the <code>Address</code> are required, if the address is invalid or unsupported, then an
 * exception is thrown.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressId").getter(getter(Address::addressId)).setter(setter(Builder::addressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Address::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> COMPANY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Company")
            .getter(getter(Address::company)).setter(setter(Builder::company))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Company").build()).build();

    private static final SdkField<String> STREET1_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Street1")
            .getter(getter(Address::street1)).setter(setter(Builder::street1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street1").build()).build();

    private static final SdkField<String> STREET2_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Street2")
            .getter(getter(Address::street2)).setter(setter(Builder::street2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street2").build()).build();

    private static final SdkField<String> STREET3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Street3")
            .getter(getter(Address::street3)).setter(setter(Builder::street3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street3").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(Address::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> STATE_OR_PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateOrProvince").getter(getter(Address::stateOrProvince)).setter(setter(Builder::stateOrProvince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrProvince").build()).build();

    private static final SdkField<String> PREFECTURE_OR_DISTRICT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrefectureOrDistrict").getter(getter(Address::prefectureOrDistrict))
            .setter(setter(Builder::prefectureOrDistrict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefectureOrDistrict").build())
            .build();

    private static final SdkField<String> LANDMARK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Landmark").getter(getter(Address::landmark)).setter(setter(Builder::landmark))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Landmark").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(Address::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(Address::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<Boolean> IS_RESTRICTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRestricted").getter(getter(Address::isRestricted)).setter(setter(Builder::isRestricted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRestricted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_ID_FIELD, NAME_FIELD,
            COMPANY_FIELD, STREET1_FIELD, STREET2_FIELD, STREET3_FIELD, CITY_FIELD, STATE_OR_PROVINCE_FIELD,
            PREFECTURE_OR_DISTRICT_FIELD, LANDMARK_FIELD, COUNTRY_FIELD, POSTAL_CODE_FIELD, PHONE_NUMBER_FIELD,
            IS_RESTRICTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addressId;

    private final String name;

    private final String company;

    private final String street1;

    private final String street2;

    private final String street3;

    private final String city;

    private final String stateOrProvince;

    private final String prefectureOrDistrict;

    private final String landmark;

    private final String country;

    private final String postalCode;

    private final String phoneNumber;

    private final Boolean isRestricted;

    private Address(BuilderImpl builder) {
        this.addressId = builder.addressId;
        this.name = builder.name;
        this.company = builder.company;
        this.street1 = builder.street1;
        this.street2 = builder.street2;
        this.street3 = builder.street3;
        this.city = builder.city;
        this.stateOrProvince = builder.stateOrProvince;
        this.prefectureOrDistrict = builder.prefectureOrDistrict;
        this.landmark = builder.landmark;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
        this.phoneNumber = builder.phoneNumber;
        this.isRestricted = builder.isRestricted;
    }

    /**
     * <p>
     * The unique ID for an address.
     * </p>
     * 
     * @return The unique ID for an address.
     */
    public final String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The name of a person to receive a Snow device at an address.
     * </p>
     * 
     * @return The name of a person to receive a Snow device at an address.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the company to receive a Snow device at an address.
     * </p>
     * 
     * @return The name of the company to receive a Snow device at an address.
     */
    public final String company() {
        return company;
    }

    /**
     * <p>
     * The first line in a street address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The first line in a street address that a Snow device is to be delivered to.
     */
    public final String street1() {
        return street1;
    }

    /**
     * <p>
     * The second line in a street address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The second line in a street address that a Snow device is to be delivered to.
     */
    public final String street2() {
        return street2;
    }

    /**
     * <p>
     * The third line in a street address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The third line in a street address that a Snow device is to be delivered to.
     */
    public final String street3() {
        return street3;
    }

    /**
     * <p>
     * The city in an address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The city in an address that a Snow device is to be delivered to.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The state or province in an address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The state or province in an address that a Snow device is to be delivered to.
     */
    public final String stateOrProvince() {
        return stateOrProvince;
    }

    /**
     * <p>
     * This field is no longer used and the value is ignored.
     * </p>
     * 
     * @return This field is no longer used and the value is ignored.
     */
    public final String prefectureOrDistrict() {
        return prefectureOrDistrict;
    }

    /**
     * <p>
     * This field is no longer used and the value is ignored.
     * </p>
     * 
     * @return This field is no longer used and the value is ignored.
     */
    public final String landmark() {
        return landmark;
    }

    /**
     * <p>
     * The country in an address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The country in an address that a Snow device is to be delivered to.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The postal code in an address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The postal code in an address that a Snow device is to be delivered to.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The phone number associated with an address that a Snow device is to be delivered to.
     * </p>
     * 
     * @return The phone number associated with an address that a Snow device is to be delivered to.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * If the address you are creating is a primary address, then set this option to true. This field is not supported
     * in most regions.
     * </p>
     * 
     * @return If the address you are creating is a primary address, then set this option to true. This field is not
     *         supported in most regions.
     */
    public final Boolean isRestricted() {
        return isRestricted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(company());
        hashCode = 31 * hashCode + Objects.hashCode(street1());
        hashCode = 31 * hashCode + Objects.hashCode(street2());
        hashCode = 31 * hashCode + Objects.hashCode(street3());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrProvince());
        hashCode = 31 * hashCode + Objects.hashCode(prefectureOrDistrict());
        hashCode = 31 * hashCode + Objects.hashCode(landmark());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(isRestricted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(addressId(), other.addressId()) && Objects.equals(name(), other.name())
                && Objects.equals(company(), other.company()) && Objects.equals(street1(), other.street1())
                && Objects.equals(street2(), other.street2()) && Objects.equals(street3(), other.street3())
                && Objects.equals(city(), other.city()) && Objects.equals(stateOrProvince(), other.stateOrProvince())
                && Objects.equals(prefectureOrDistrict(), other.prefectureOrDistrict())
                && Objects.equals(landmark(), other.landmark()) && Objects.equals(country(), other.country())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(isRestricted(), other.isRestricted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("AddressId", addressId()).add("Name", name()).add("Company", company())
                .add("Street1", street1()).add("Street2", street2()).add("Street3", street3()).add("City", city())
                .add("StateOrProvince", stateOrProvince()).add("PrefectureOrDistrict", prefectureOrDistrict())
                .add("Landmark", landmark()).add("Country", country()).add("PostalCode", postalCode())
                .add("PhoneNumber", phoneNumber()).add("IsRestricted", isRestricted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressId":
            return Optional.ofNullable(clazz.cast(addressId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Company":
            return Optional.ofNullable(clazz.cast(company()));
        case "Street1":
            return Optional.ofNullable(clazz.cast(street1()));
        case "Street2":
            return Optional.ofNullable(clazz.cast(street2()));
        case "Street3":
            return Optional.ofNullable(clazz.cast(street3()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "StateOrProvince":
            return Optional.ofNullable(clazz.cast(stateOrProvince()));
        case "PrefectureOrDistrict":
            return Optional.ofNullable(clazz.cast(prefectureOrDistrict()));
        case "Landmark":
            return Optional.ofNullable(clazz.cast(landmark()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "IsRestricted":
            return Optional.ofNullable(clazz.cast(isRestricted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The unique ID for an address.
         * </p>
         * 
         * @param addressId
         *        The unique ID for an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The name of a person to receive a Snow device at an address.
         * </p>
         * 
         * @param name
         *        The name of a person to receive a Snow device at an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the company to receive a Snow device at an address.
         * </p>
         * 
         * @param company
         *        The name of the company to receive a Snow device at an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder company(String company);

        /**
         * <p>
         * The first line in a street address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param street1
         *        The first line in a street address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street1(String street1);

        /**
         * <p>
         * The second line in a street address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param street2
         *        The second line in a street address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street2(String street2);

        /**
         * <p>
         * The third line in a street address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param street3
         *        The third line in a street address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street3(String street3);

        /**
         * <p>
         * The city in an address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param city
         *        The city in an address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state or province in an address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param stateOrProvince
         *        The state or province in an address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrProvince(String stateOrProvince);

        /**
         * <p>
         * This field is no longer used and the value is ignored.
         * </p>
         * 
         * @param prefectureOrDistrict
         *        This field is no longer used and the value is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefectureOrDistrict(String prefectureOrDistrict);

        /**
         * <p>
         * This field is no longer used and the value is ignored.
         * </p>
         * 
         * @param landmark
         *        This field is no longer used and the value is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landmark(String landmark);

        /**
         * <p>
         * The country in an address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param country
         *        The country in an address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The postal code in an address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param postalCode
         *        The postal code in an address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The phone number associated with an address that a Snow device is to be delivered to.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number associated with an address that a Snow device is to be delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * If the address you are creating is a primary address, then set this option to true. This field is not
         * supported in most regions.
         * </p>
         * 
         * @param isRestricted
         *        If the address you are creating is a primary address, then set this option to true. This field is not
         *        supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRestricted(Boolean isRestricted);
    }

    static final class BuilderImpl implements Builder {
        private String addressId;

        private String name;

        private String company;

        private String street1;

        private String street2;

        private String street3;

        private String city;

        private String stateOrProvince;

        private String prefectureOrDistrict;

        private String landmark;

        private String country;

        private String postalCode;

        private String phoneNumber;

        private Boolean isRestricted;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            addressId(model.addressId);
            name(model.name);
            company(model.company);
            street1(model.street1);
            street2(model.street2);
            street3(model.street3);
            city(model.city);
            stateOrProvince(model.stateOrProvince);
            prefectureOrDistrict(model.prefectureOrDistrict);
            landmark(model.landmark);
            country(model.country);
            postalCode(model.postalCode);
            phoneNumber(model.phoneNumber);
            isRestricted(model.isRestricted);
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCompany() {
            return company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        public final String getStreet1() {
            return street1;
        }

        @Override
        public final Builder street1(String street1) {
            this.street1 = street1;
            return this;
        }

        public final void setStreet1(String street1) {
            this.street1 = street1;
        }

        public final String getStreet2() {
            return street2;
        }

        @Override
        public final Builder street2(String street2) {
            this.street2 = street2;
            return this;
        }

        public final void setStreet2(String street2) {
            this.street2 = street2;
        }

        public final String getStreet3() {
            return street3;
        }

        @Override
        public final Builder street3(String street3) {
            this.street3 = street3;
            return this;
        }

        public final void setStreet3(String street3) {
            this.street3 = street3;
        }

        public final String getCity() {
            return city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getStateOrProvince() {
            return stateOrProvince;
        }

        @Override
        public final Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return this;
        }

        public final void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        public final String getPrefectureOrDistrict() {
            return prefectureOrDistrict;
        }

        @Override
        public final Builder prefectureOrDistrict(String prefectureOrDistrict) {
            this.prefectureOrDistrict = prefectureOrDistrict;
            return this;
        }

        public final void setPrefectureOrDistrict(String prefectureOrDistrict) {
            this.prefectureOrDistrict = prefectureOrDistrict;
        }

        public final String getLandmark() {
            return landmark;
        }

        @Override
        public final Builder landmark(String landmark) {
            this.landmark = landmark;
            return this;
        }

        public final void setLandmark(String landmark) {
            this.landmark = landmark;
        }

        public final String getCountry() {
            return country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final Boolean getIsRestricted() {
            return isRestricted;
        }

        @Override
        public final Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            return this;
        }

        public final void setIsRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
