/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLongTermPricingResponse extends SnowballResponse implements
        ToCopyableBuilder<CreateLongTermPricingResponse.Builder, CreateLongTermPricingResponse> {
    private static final SdkField<String> LONG_TERM_PRICING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongTermPricingId").getter(getter(CreateLongTermPricingResponse::longTermPricingId))
            .setter(setter(Builder::longTermPricingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_ID_FIELD));

    private final String longTermPricingId;

    private CreateLongTermPricingResponse(BuilderImpl builder) {
        super(builder);
        this.longTermPricingId = builder.longTermPricingId;
    }

    /**
     * <p>
     * The ID of the long-term pricing type for the device.
     * </p>
     * 
     * @return The ID of the long-term pricing type for the device.
     */
    public final String longTermPricingId() {
        return longTermPricingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(longTermPricingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLongTermPricingResponse)) {
            return false;
        }
        CreateLongTermPricingResponse other = (CreateLongTermPricingResponse) obj;
        return Objects.equals(longTermPricingId(), other.longTermPricingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLongTermPricingResponse").add("LongTermPricingId", longTermPricingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LongTermPricingId":
            return Optional.ofNullable(clazz.cast(longTermPricingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLongTermPricingResponse, T> g) {
        return obj -> g.apply((CreateLongTermPricingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateLongTermPricingResponse> {
        /**
         * <p>
         * The ID of the long-term pricing type for the device.
         * </p>
         * 
         * @param longTermPricingId
         *        The ID of the long-term pricing type for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longTermPricingId(String longTermPricingId);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String longTermPricingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLongTermPricingResponse model) {
            super(model);
            longTermPricingId(model.longTermPricingId);
        }

        public final String getLongTermPricingId() {
            return longTermPricingId;
        }

        @Override
        public final Builder longTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
            return this;
        }

        public final void setLongTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
        }

        @Override
        public CreateLongTermPricingResponse build() {
            return new CreateLongTermPricingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
