/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax documents required in Amazon Web Services Region in India.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class INDTaxDocuments implements SdkPojo, Serializable, ToCopyableBuilder<INDTaxDocuments.Builder, INDTaxDocuments> {
    private static final SdkField<String> GSTIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("GSTIN")
            .getter(getter(INDTaxDocuments::gstin)).setter(setter(Builder::gstin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GSTIN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GSTIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gstin;

    private INDTaxDocuments(BuilderImpl builder) {
        this.gstin = builder.gstin;
    }

    /**
     * <p>
     * The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.
     * </p>
     * 
     * @return The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.
     */
    public final String gstin() {
        return gstin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gstin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof INDTaxDocuments)) {
            return false;
        }
        INDTaxDocuments other = (INDTaxDocuments) obj;
        return Objects.equals(gstin(), other.gstin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("INDTaxDocuments").add("GSTIN", gstin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GSTIN":
            return Optional.ofNullable(clazz.cast(gstin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<INDTaxDocuments, T> g) {
        return obj -> g.apply((INDTaxDocuments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, INDTaxDocuments> {
        /**
         * <p>
         * The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.
         * </p>
         * 
         * @param gstin
         *        The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gstin(String gstin);
    }

    static final class BuilderImpl implements Builder {
        private String gstin;

        private BuilderImpl() {
        }

        private BuilderImpl(INDTaxDocuments model) {
            gstin(model.gstin);
        }

        public final String getGstin() {
            return gstin;
        }

        public final void setGstin(String gstin) {
            this.gstin = gstin;
        }

        @Override
        @Transient
        public final Builder gstin(String gstin) {
            this.gstin = gstin;
            return this;
        }

        @Override
        public INDTaxDocuments build() {
            return new INDTaxDocuments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
