/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReturnShippingLabelRequest extends SnowballRequest implements
        ToCopyableBuilder<CreateReturnShippingLabelRequest.Builder, CreateReturnShippingLabelRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(CreateReturnShippingLabelRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShippingOption").getter(getter(CreateReturnShippingLabelRequest::shippingOptionAsString))
            .setter(setter(Builder::shippingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            SHIPPING_OPTION_FIELD));

    private final String jobId;

    private final String shippingOption;

    private CreateReturnShippingLabelRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.shippingOption = builder.shippingOption;
    }

    /**
     * <p>
     * The ID for a job that you want to create the return shipping label for; for example,
     * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The ID for a job that you want to create the return shipping label for; for example,
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web
     * Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping
     * speeds are as follows:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to
     *         Amazon Web Services. This speed represents how quickly it moves to its destination while in transit.
     *         Regional shipping speeds are as follows:
     * @see ShippingOption
     */
    public final ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web
     * Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping
     * speeds are as follows:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to
     *         Amazon Web Services. This speed represents how quickly it moves to its destination while in transit.
     *         Regional shipping speeds are as follows:
     * @see ShippingOption
     */
    public final String shippingOptionAsString() {
        return shippingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(shippingOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReturnShippingLabelRequest)) {
            return false;
        }
        CreateReturnShippingLabelRequest other = (CreateReturnShippingLabelRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(shippingOptionAsString(), other.shippingOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReturnShippingLabelRequest").add("JobId", jobId())
                .add("ShippingOption", shippingOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ShippingOption":
            return Optional.ofNullable(clazz.cast(shippingOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReturnShippingLabelRequest, T> g) {
        return obj -> g.apply((CreateReturnShippingLabelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReturnShippingLabelRequest> {
        /**
         * <p>
         * The ID for a job that you want to create the return shipping label for; for example,
         * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The ID for a job that you want to create the return shipping label for; for example,
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon
         * Web Services. This speed represents how quickly it moves to its destination while in transit. Regional
         * shipping speeds are as follows:
         * </p>
         * 
         * @param shippingOption
         *        The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to
         *        Amazon Web Services. This speed represents how quickly it moves to its destination while in transit.
         *        Regional shipping speeds are as follows:
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon
         * Web Services. This speed represents how quickly it moves to its destination while in transit. Regional
         * shipping speeds are as follows:
         * </p>
         * 
         * @param shippingOption
         *        The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to
         *        Amazon Web Services. This speed represents how quickly it moves to its destination while in transit.
         *        Regional shipping speeds are as follows:
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String jobId;

        private String shippingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReturnShippingLabelRequest model) {
            super(model);
            jobId(model.jobId);
            shippingOption(model.shippingOption);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        @Override
        @Transient
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        @Transient
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReturnShippingLabelRequest build() {
            return new CreateReturnShippingLabelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
