/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the metadata and configuration settings for services on an Amazon Web Services Snow Family
 * device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDeviceServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OnDeviceServiceConfiguration.Builder, OnDeviceServiceConfiguration> {
    private static final SdkField<NFSOnDeviceServiceConfiguration> NFS_ON_DEVICE_SERVICE_FIELD = SdkField
            .<NFSOnDeviceServiceConfiguration> builder(MarshallingType.SDK_POJO).memberName("NFSOnDeviceService")
            .getter(getter(OnDeviceServiceConfiguration::nfsOnDeviceService)).setter(setter(Builder::nfsOnDeviceService))
            .constructor(NFSOnDeviceServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSOnDeviceService").build())
            .build();

    private static final SdkField<TGWOnDeviceServiceConfiguration> TGW_ON_DEVICE_SERVICE_FIELD = SdkField
            .<TGWOnDeviceServiceConfiguration> builder(MarshallingType.SDK_POJO).memberName("TGWOnDeviceService")
            .getter(getter(OnDeviceServiceConfiguration::tgwOnDeviceService)).setter(setter(Builder::tgwOnDeviceService))
            .constructor(TGWOnDeviceServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TGWOnDeviceService").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_ON_DEVICE_SERVICE_FIELD,
            TGW_ON_DEVICE_SERVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final NFSOnDeviceServiceConfiguration nfsOnDeviceService;

    private final TGWOnDeviceServiceConfiguration tgwOnDeviceService;

    private OnDeviceServiceConfiguration(BuilderImpl builder) {
        this.nfsOnDeviceService = builder.nfsOnDeviceService;
        this.tgwOnDeviceService = builder.tgwOnDeviceService;
    }

    /**
     * <p>
     * Represents the NFS (Network File System) service on a Snow Family device.
     * </p>
     * 
     * @return Represents the NFS (Network File System) service on a Snow Family device.
     */
    public final NFSOnDeviceServiceConfiguration nfsOnDeviceService() {
        return nfsOnDeviceService;
    }

    /**
     * <p>
     * Represents the Storage Gateway service Tape Gateway type on a Snow Family device.
     * </p>
     * 
     * @return Represents the Storage Gateway service Tape Gateway type on a Snow Family device.
     */
    public final TGWOnDeviceServiceConfiguration tgwOnDeviceService() {
        return tgwOnDeviceService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nfsOnDeviceService());
        hashCode = 31 * hashCode + Objects.hashCode(tgwOnDeviceService());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDeviceServiceConfiguration)) {
            return false;
        }
        OnDeviceServiceConfiguration other = (OnDeviceServiceConfiguration) obj;
        return Objects.equals(nfsOnDeviceService(), other.nfsOnDeviceService())
                && Objects.equals(tgwOnDeviceService(), other.tgwOnDeviceService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnDeviceServiceConfiguration").add("NFSOnDeviceService", nfsOnDeviceService())
                .add("TGWOnDeviceService", tgwOnDeviceService()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NFSOnDeviceService":
            return Optional.ofNullable(clazz.cast(nfsOnDeviceService()));
        case "TGWOnDeviceService":
            return Optional.ofNullable(clazz.cast(tgwOnDeviceService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((OnDeviceServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDeviceServiceConfiguration> {
        /**
         * <p>
         * Represents the NFS (Network File System) service on a Snow Family device.
         * </p>
         * 
         * @param nfsOnDeviceService
         *        Represents the NFS (Network File System) service on a Snow Family device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsOnDeviceService(NFSOnDeviceServiceConfiguration nfsOnDeviceService);

        /**
         * <p>
         * Represents the NFS (Network File System) service on a Snow Family device.
         * </p>
         * This is a convenience that creates an instance of the {@link NFSOnDeviceServiceConfiguration.Builder}
         * avoiding the need to create one manually via {@link NFSOnDeviceServiceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NFSOnDeviceServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #nfsOnDeviceService(NFSOnDeviceServiceConfiguration)}.
         * 
         * @param nfsOnDeviceService
         *        a consumer that will call methods on {@link NFSOnDeviceServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfsOnDeviceService(NFSOnDeviceServiceConfiguration)
         */
        default Builder nfsOnDeviceService(Consumer<NFSOnDeviceServiceConfiguration.Builder> nfsOnDeviceService) {
            return nfsOnDeviceService(NFSOnDeviceServiceConfiguration.builder().applyMutation(nfsOnDeviceService).build());
        }

        /**
         * <p>
         * Represents the Storage Gateway service Tape Gateway type on a Snow Family device.
         * </p>
         * 
         * @param tgwOnDeviceService
         *        Represents the Storage Gateway service Tape Gateway type on a Snow Family device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tgwOnDeviceService(TGWOnDeviceServiceConfiguration tgwOnDeviceService);

        /**
         * <p>
         * Represents the Storage Gateway service Tape Gateway type on a Snow Family device.
         * </p>
         * This is a convenience that creates an instance of the {@link TGWOnDeviceServiceConfiguration.Builder}
         * avoiding the need to create one manually via {@link TGWOnDeviceServiceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TGWOnDeviceServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tgwOnDeviceService(TGWOnDeviceServiceConfiguration)}.
         * 
         * @param tgwOnDeviceService
         *        a consumer that will call methods on {@link TGWOnDeviceServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tgwOnDeviceService(TGWOnDeviceServiceConfiguration)
         */
        default Builder tgwOnDeviceService(Consumer<TGWOnDeviceServiceConfiguration.Builder> tgwOnDeviceService) {
            return tgwOnDeviceService(TGWOnDeviceServiceConfiguration.builder().applyMutation(tgwOnDeviceService).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NFSOnDeviceServiceConfiguration nfsOnDeviceService;

        private TGWOnDeviceServiceConfiguration tgwOnDeviceService;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDeviceServiceConfiguration model) {
            nfsOnDeviceService(model.nfsOnDeviceService);
            tgwOnDeviceService(model.tgwOnDeviceService);
        }

        public final NFSOnDeviceServiceConfiguration.Builder getNfsOnDeviceService() {
            return nfsOnDeviceService != null ? nfsOnDeviceService.toBuilder() : null;
        }

        public final void setNfsOnDeviceService(NFSOnDeviceServiceConfiguration.BuilderImpl nfsOnDeviceService) {
            this.nfsOnDeviceService = nfsOnDeviceService != null ? nfsOnDeviceService.build() : null;
        }

        @Override
        @Transient
        public final Builder nfsOnDeviceService(NFSOnDeviceServiceConfiguration nfsOnDeviceService) {
            this.nfsOnDeviceService = nfsOnDeviceService;
            return this;
        }

        public final TGWOnDeviceServiceConfiguration.Builder getTgwOnDeviceService() {
            return tgwOnDeviceService != null ? tgwOnDeviceService.toBuilder() : null;
        }

        public final void setTgwOnDeviceService(TGWOnDeviceServiceConfiguration.BuilderImpl tgwOnDeviceService) {
            this.tgwOnDeviceService = tgwOnDeviceService != null ? tgwOnDeviceService.build() : null;
        }

        @Override
        @Transient
        public final Builder tgwOnDeviceService(TGWOnDeviceServiceConfiguration tgwOnDeviceService) {
            this.tgwOnDeviceService = tgwOnDeviceService;
            return this;
        }

        @Override
        public OnDeviceServiceConfiguration build() {
            return new OnDeviceServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
