/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterJobsResponse extends SnowballResponse implements
        ToCopyableBuilder<ListClusterJobsResponse.Builder, ListClusterJobsResponse> {
    private static final SdkField<List<JobListEntry>> JOB_LIST_ENTRIES_FIELD = SdkField
            .<List<JobListEntry>> builder(MarshallingType.LIST)
            .memberName("JobListEntries")
            .getter(getter(ListClusterJobsResponse::jobListEntries))
            .setter(setter(Builder::jobListEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobListEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_LIST_ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JobListEntry> jobListEntries;

    private final String nextToken;

    private ListClusterJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobListEntries = builder.jobListEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the JobListEntries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobListEntries() {
        return jobListEntries != null && !(jobListEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the
     * job is a job part, in the case of export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobListEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
     *         whether the job is a job part, in the case of export jobs.
     */
    public final List<JobListEntry> jobListEntries() {
        return jobListEntries;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in
     *         the array.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobListEntries() ? jobListEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterJobsResponse)) {
            return false;
        }
        ListClusterJobsResponse other = (ListClusterJobsResponse) obj;
        return hasJobListEntries() == other.hasJobListEntries() && Objects.equals(jobListEntries(), other.jobListEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterJobsResponse").add("JobListEntries", hasJobListEntries() ? jobListEntries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobListEntries":
            return Optional.ofNullable(clazz.cast(jobListEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterJobsResponse, T> g) {
        return obj -> g.apply((ListClusterJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClusterJobsResponse> {
        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * 
         * @param jobListEntries
         *        Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
         *        whether the job is a job part, in the case of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(Collection<JobListEntry> jobListEntries);

        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * 
         * @param jobListEntries
         *        Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
         *        whether the job is a job part, in the case of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(JobListEntry... jobListEntries);

        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobListEntry>.Builder} avoiding the need to
         * create one manually via {@link List<JobListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobListEntries(List<JobListEntry>)}.
         * 
         * @param jobListEntries
         *        a consumer that will call methods on {@link List<JobListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobListEntries(List<JobListEntry>)
         */
        Builder jobListEntries(Consumer<JobListEntry.Builder>... jobListEntries);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<JobListEntry> jobListEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterJobsResponse model) {
            super(model);
            jobListEntries(model.jobListEntries);
            nextToken(model.nextToken);
        }

        public final List<JobListEntry.Builder> getJobListEntries() {
            List<JobListEntry.Builder> result = JobListEntryListCopier.copyToBuilder(this.jobListEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobListEntries(Collection<JobListEntry.BuilderImpl> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copyFromBuilder(jobListEntries);
        }

        @Override
        @Transient
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry... jobListEntries) {
            jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobListEntries(Consumer<JobListEntry.Builder>... jobListEntries) {
            jobListEntries(Stream.of(jobListEntries).map(c -> JobListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClusterJobsResponse build() {
            return new ListClusterJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
