/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersResponse extends SnowballResponse implements
        ToCopyableBuilder<ListClustersResponse.Builder, ListClustersResponse> {
    private static final SdkField<List<ClusterListEntry>> CLUSTER_LIST_ENTRIES_FIELD = SdkField
            .<List<ClusterListEntry>> builder(MarshallingType.LIST)
            .memberName("ClusterListEntries")
            .getter(getter(ListClustersResponse::clusterListEntries))
            .setter(setter(Builder::clusterListEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterListEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_LIST_ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ClusterListEntry> clusterListEntries;

    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusterListEntries = builder.clusterListEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterListEntries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterListEntries() {
        return clusterListEntries != null && !(clusterListEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterListEntries} method.
     * </p>
     * 
     * @return Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
     *         status information.
     */
    public final List<ClusterListEntry> clusterListEntries() {
        return clusterListEntries;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the
     *         array.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterListEntries() ? clusterListEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse) obj;
        return hasClusterListEntries() == other.hasClusterListEntries()
                && Objects.equals(clusterListEntries(), other.clusterListEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersResponse")
                .add("ClusterListEntries", hasClusterListEntries() ? clusterListEntries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterListEntries":
            return Optional.ofNullable(clazz.cast(clusterListEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersResponse> {
        /**
         * <p>
         * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
         * status information.
         * </p>
         * 
         * @param clusterListEntries
         *        Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other
         *        important status information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries);

        /**
         * <p>
         * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
         * status information.
         * </p>
         * 
         * @param clusterListEntries
         *        Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other
         *        important status information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterListEntries(ClusterListEntry... clusterListEntries);

        /**
         * <p>
         * Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important
         * status information.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ClusterListEntry>.Builder} avoiding
         * the need to create one manually via {@link List<ClusterListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterListEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterListEntries(List<ClusterListEntry>)}.
         * 
         * @param clusterListEntries
         *        a consumer that will call methods on {@link List<ClusterListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterListEntries(List<ClusterListEntry>)
         */
        Builder clusterListEntries(Consumer<ClusterListEntry.Builder>... clusterListEntries);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>ClusterListEntry</code> call, your list of returned clusters will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<ClusterListEntry> clusterListEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            clusterListEntries(model.clusterListEntries);
            nextToken(model.nextToken);
        }

        public final List<ClusterListEntry.Builder> getClusterListEntries() {
            List<ClusterListEntry.Builder> result = ClusterListEntryListCopier.copyToBuilder(this.clusterListEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterListEntries(Collection<ClusterListEntry.BuilderImpl> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copyFromBuilder(clusterListEntries);
        }

        @Override
        @Transient
        public final Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copy(clusterListEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterListEntries(ClusterListEntry... clusterListEntries) {
            clusterListEntries(Arrays.asList(clusterListEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterListEntries(Consumer<ClusterListEntry.Builder>... clusterListEntries) {
            clusterListEntries(Stream.of(clusterListEntries).map(c -> ClusterListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
