/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLongTermPricingRequest extends SnowballRequest implements
        ToCopyableBuilder<CreateLongTermPricingRequest.Builder, CreateLongTermPricingRequest> {
    private static final SdkField<String> LONG_TERM_PRICING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongTermPricingType").getter(getter(CreateLongTermPricingRequest::longTermPricingTypeAsString))
            .setter(setter(Builder::longTermPricingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingType").build())
            .build();

    private static final SdkField<Boolean> IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLongTermPricingAutoRenew")
            .getter(getter(CreateLongTermPricingRequest::isLongTermPricingAutoRenew))
            .setter(setter(Builder::isLongTermPricingAutoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLongTermPricingAutoRenew").build())
            .build();

    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnowballType").getter(getter(CreateLongTermPricingRequest::snowballTypeAsString))
            .setter(setter(Builder::snowballType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_TYPE_FIELD,
            IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD, SNOWBALL_TYPE_FIELD));

    private final String longTermPricingType;

    private final Boolean isLongTermPricingAutoRenew;

    private final String snowballType;

    private CreateLongTermPricingRequest(BuilderImpl builder) {
        super(builder);
        this.longTermPricingType = builder.longTermPricingType;
        this.isLongTermPricingAutoRenew = builder.isLongTermPricingAutoRenew;
        this.snowballType = builder.snowballType;
    }

    /**
     * <p>
     * The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #longTermPricingType} will return {@link LongTermPricingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #longTermPricingTypeAsString}.
     * </p>
     * 
     * @return The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
     * @see LongTermPricingType
     */
    public final LongTermPricingType longTermPricingType() {
        return LongTermPricingType.fromValue(longTermPricingType);
    }

    /**
     * <p>
     * The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #longTermPricingType} will return {@link LongTermPricingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #longTermPricingTypeAsString}.
     * </p>
     * 
     * @return The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
     * @see LongTermPricingType
     */
    public final String longTermPricingTypeAsString() {
        return longTermPricingType;
    }

    /**
     * <p>
     * Specifies whether the current long-term pricing type for the device should be renewed.
     * </p>
     * 
     * @return Specifies whether the current long-term pricing type for the device should be renewed.
     */
    public final Boolean isLongTermPricingAutoRenew() {
        return isLongTermPricingAutoRenew;
    }

    /**
     * <p>
     * The type of Snow Family Devices to use for the long-term pricing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of Snow Family Devices to use for the long-term pricing job.
     * @see SnowballType
     */
    public final SnowballType snowballType() {
        return SnowballType.fromValue(snowballType);
    }

    /**
     * <p>
     * The type of Snow Family Devices to use for the long-term pricing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of Snow Family Devices to use for the long-term pricing job.
     * @see SnowballType
     */
    public final String snowballTypeAsString() {
        return snowballType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(longTermPricingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isLongTermPricingAutoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(snowballTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLongTermPricingRequest)) {
            return false;
        }
        CreateLongTermPricingRequest other = (CreateLongTermPricingRequest) obj;
        return Objects.equals(longTermPricingTypeAsString(), other.longTermPricingTypeAsString())
                && Objects.equals(isLongTermPricingAutoRenew(), other.isLongTermPricingAutoRenew())
                && Objects.equals(snowballTypeAsString(), other.snowballTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLongTermPricingRequest").add("LongTermPricingType", longTermPricingTypeAsString())
                .add("IsLongTermPricingAutoRenew", isLongTermPricingAutoRenew()).add("SnowballType", snowballTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LongTermPricingType":
            return Optional.ofNullable(clazz.cast(longTermPricingTypeAsString()));
        case "IsLongTermPricingAutoRenew":
            return Optional.ofNullable(clazz.cast(isLongTermPricingAutoRenew()));
        case "SnowballType":
            return Optional.ofNullable(clazz.cast(snowballTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLongTermPricingRequest, T> g) {
        return obj -> g.apply((CreateLongTermPricingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLongTermPricingRequest> {
        /**
         * <p>
         * The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
         * </p>
         * 
         * @param longTermPricingType
         *        The type of long-term pricing option you want for the device, either 1-year or 3-year long-term
         *        pricing.
         * @see LongTermPricingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LongTermPricingType
         */
        Builder longTermPricingType(String longTermPricingType);

        /**
         * <p>
         * The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
         * </p>
         * 
         * @param longTermPricingType
         *        The type of long-term pricing option you want for the device, either 1-year or 3-year long-term
         *        pricing.
         * @see LongTermPricingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LongTermPricingType
         */
        Builder longTermPricingType(LongTermPricingType longTermPricingType);

        /**
         * <p>
         * Specifies whether the current long-term pricing type for the device should be renewed.
         * </p>
         * 
         * @param isLongTermPricingAutoRenew
         *        Specifies whether the current long-term pricing type for the device should be renewed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew);

        /**
         * <p>
         * The type of Snow Family Devices to use for the long-term pricing job.
         * </p>
         * 
         * @param snowballType
         *        The type of Snow Family Devices to use for the long-term pricing job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of Snow Family Devices to use for the long-term pricing job.
         * </p>
         * 
         * @param snowballType
         *        The type of Snow Family Devices to use for the long-term pricing job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String longTermPricingType;

        private Boolean isLongTermPricingAutoRenew;

        private String snowballType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLongTermPricingRequest model) {
            super(model);
            longTermPricingType(model.longTermPricingType);
            isLongTermPricingAutoRenew(model.isLongTermPricingAutoRenew);
            snowballType(model.snowballType);
        }

        public final String getLongTermPricingType() {
            return longTermPricingType;
        }

        public final void setLongTermPricingType(String longTermPricingType) {
            this.longTermPricingType = longTermPricingType;
        }

        @Override
        public final Builder longTermPricingType(String longTermPricingType) {
            this.longTermPricingType = longTermPricingType;
            return this;
        }

        @Override
        public final Builder longTermPricingType(LongTermPricingType longTermPricingType) {
            this.longTermPricingType(longTermPricingType == null ? null : longTermPricingType.toString());
            return this;
        }

        public final Boolean getIsLongTermPricingAutoRenew() {
            return isLongTermPricingAutoRenew;
        }

        public final void setIsLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
        }

        @Override
        public final Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
            return this;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLongTermPricingRequest build() {
            return new CreateLongTermPricingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
