/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends SnowballRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(CreateJobRequest::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.<JobResource> builder(MarshallingType.SDK_POJO)
            .memberName("Resources").getter(getter(CreateJobRequest::resources)).setter(setter(Builder::resources))
            .constructor(JobResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()).build();

    private static final SdkField<OnDeviceServiceConfiguration> ON_DEVICE_SERVICE_CONFIGURATION_FIELD = SdkField
            .<OnDeviceServiceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("OnDeviceServiceConfiguration")
            .getter(getter(CreateJobRequest::onDeviceServiceConfiguration))
            .setter(setter(Builder::onDeviceServiceConfiguration))
            .constructor(OnDeviceServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDeviceServiceConfiguration")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressId").getter(getter(CreateJobRequest::addressId)).setter(setter(Builder::addressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyARN").getter(getter(CreateJobRequest::kmsKeyARN)).setter(setter(Builder::kmsKeyARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyARN").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(CreateJobRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnowballCapacityPreference")
            .getter(getter(CreateJobRequest::snowballCapacityPreferenceAsString))
            .setter(setter(Builder::snowballCapacityPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build())
            .build();

    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShippingOption").getter(getter(CreateJobRequest::shippingOptionAsString))
            .setter(setter(Builder::shippingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()).build();

    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.<Notification> builder(MarshallingType.SDK_POJO)
            .memberName("Notification").getter(getter(CreateJobRequest::notification)).setter(setter(Builder::notification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(CreateJobRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnowballType").getter(getter(CreateJobRequest::snowballTypeAsString))
            .setter(setter(Builder::snowballType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()).build();

    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForwardingAddressId").getter(getter(CreateJobRequest::forwardingAddressId))
            .setter(setter(Builder::forwardingAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build())
            .build();

    private static final SdkField<TaxDocuments> TAX_DOCUMENTS_FIELD = SdkField.<TaxDocuments> builder(MarshallingType.SDK_POJO)
            .memberName("TaxDocuments").getter(getter(CreateJobRequest::taxDocuments)).setter(setter(Builder::taxDocuments))
            .constructor(TaxDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxDocuments").build()).build();

    private static final SdkField<DeviceConfiguration> DEVICE_CONFIGURATION_FIELD = SdkField
            .<DeviceConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeviceConfiguration")
            .getter(getter(CreateJobRequest::deviceConfiguration)).setter(setter(Builder::deviceConfiguration))
            .constructor(DeviceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build())
            .build();

    private static final SdkField<String> REMOTE_MANAGEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteManagement").getter(getter(CreateJobRequest::remoteManagementAsString))
            .setter(setter(Builder::remoteManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteManagement").build()).build();

    private static final SdkField<String> LONG_TERM_PRICING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongTermPricingId").getter(getter(CreateJobRequest::longTermPricingId))
            .setter(setter(Builder::longTermPricingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TYPE_FIELD,
            RESOURCES_FIELD, ON_DEVICE_SERVICE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, ADDRESS_ID_FIELD, KMS_KEY_ARN_FIELD,
            ROLE_ARN_FIELD, SNOWBALL_CAPACITY_PREFERENCE_FIELD, SHIPPING_OPTION_FIELD, NOTIFICATION_FIELD, CLUSTER_ID_FIELD,
            SNOWBALL_TYPE_FIELD, FORWARDING_ADDRESS_ID_FIELD, TAX_DOCUMENTS_FIELD, DEVICE_CONFIGURATION_FIELD,
            REMOTE_MANAGEMENT_FIELD, LONG_TERM_PRICING_ID_FIELD));

    private final String jobType;

    private final JobResource resources;

    private final OnDeviceServiceConfiguration onDeviceServiceConfiguration;

    private final String description;

    private final String addressId;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String snowballCapacityPreference;

    private final String shippingOption;

    private final Notification notification;

    private final String clusterId;

    private final String snowballType;

    private final String forwardingAddressId;

    private final TaxDocuments taxDocuments;

    private final DeviceConfiguration deviceConfiguration;

    private final String remoteManagement;

    private final String longTermPricingId;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.onDeviceServiceConfiguration = builder.onDeviceServiceConfiguration;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.clusterId = builder.clusterId;
        this.snowballType = builder.snowballType;
        this.forwardingAddressId = builder.forwardingAddressId;
        this.taxDocuments = builder.taxDocuments;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.remoteManagement = builder.remoteManagement;
        this.longTermPricingId = builder.longTermPricingId;
    }

    /**
     * <p>
     * Defines the type of job that you're creating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Defines the type of job that you're creating.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * Defines the type of job that you're creating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Defines the type of job that you're creating.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * Defines the Amazon S3 buckets associated with this job.
     * </p>
     * <p>
     * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
     * into.
     * </p>
     * <p>
     * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
     * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define
     * the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
     * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
     * </p>
     * 
     * @return Defines the Amazon S3 buckets associated with this job.</p>
     *         <p>
     *         With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
     *         imported into.
     *         </p>
     *         <p>
     *         With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
     *         exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a
     *         range, you define the length of the range by providing either an inclusive <code>BeginMarker</code>
     *         value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
     */
    public final JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or
     * imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon
     * Web Services Storage Gateway service Tape Gateway type.
     * </p>
     * 
     * @return Specifies the service or services on the Snow Family device that your transferred data will be exported
     *         from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System)
     *         and the Amazon Web Services Storage Gateway service Tape Gateway type.
     */
    public final OnDeviceServiceConfiguration onDeviceServiceConfiguration() {
        return onDeviceServiceConfiguration;
    }

    /**
     * <p>
     * Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     * </p>
     * 
     * @return Defines an optional description of this specific job, for example
     *         <code>Important Photos 2016-08-11</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID for the address that you want the Snow device shipped to.
     * </p>
     * 
     * @return The ID for the address that you want the Snow device shipped to.
     */
    public final String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using
     * the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management
     * Service (KMS) API action.
     * </p>
     * 
     * @return The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created
     *         using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a>
     *         Key Management Service (KMS) API action.
     */
    public final String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access
     * Management (IAM) API action.
     * </p>
     * 
     * @return The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created
     *         using the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity
     *         and Access Management (IAM) API action.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *         device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballCapacity
     */
    public final SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(snowballCapacityPreference);
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *         device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballCapacity
     */
    public final String snowballCapacityPreferenceAsString() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it
     * represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather
     *         it represents how quickly the Snow device moves to its destination while in transit. Regional shipping
     *         speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *         in about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *         are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *         which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snow devices are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public final ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it
     * represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather
     *         it represents how quickly the Snow device moves to its destination while in transit. Regional shipping
     *         speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *         in about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *         are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *         which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snow devices are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public final String shippingOptionAsString() {
        return shippingOption;
    }

    /**
     * <p>
     * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     * </p>
     * 
     * @return Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     */
    public final Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
     * <code>clusterId</code> value. The other job attributes are inherited from the cluster.
     * </p>
     * 
     * @return The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
     *         <code>clusterId</code> value. The other job attributes are inherited from the cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The type of Snow Family Devices to use for this job.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for
     * cluster jobs is <code>EDGE</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device
     * Options</a> in the Snowball Edge Developer Guide.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of Snow Family Devices to use for this job. </p> <note>
     *         <p>
     *         For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *         type.
     *         </p>
     *         </note>
     *         <p>
     *         The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device
     *         type for cluster jobs is <code>EDGE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge
     *         Device Options</a> in the Snowball Edge Developer Guide.
     *         </p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballType
     */
    public final SnowballType snowballType() {
        return SnowballType.fromValue(snowballType);
    }

    /**
     * <p>
     * The type of Snow Family Devices to use for this job.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for
     * cluster jobs is <code>EDGE</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device
     * Options</a> in the Snowball Edge Developer Guide.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of Snow Family Devices to use for this job. </p> <note>
     *         <p>
     *         For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *         type.
     *         </p>
     *         </note>
     *         <p>
     *         The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device
     *         type for cluster jobs is <code>EDGE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge
     *         Device Options</a> in the Snowball Edge Developer Guide.
     *         </p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballType
     */
    public final String snowballTypeAsString() {
        return snowballType;
    }

    /**
     * <p>
     * The forwarding address ID for a job. This field is not supported in most Regions.
     * </p>
     * 
     * @return The forwarding address ID for a job. This field is not supported in most Regions.
     */
    public final String forwardingAddressId() {
        return forwardingAddressId;
    }

    /**
     * <p>
     * The tax documents required in your Amazon Web Services Region.
     * </p>
     * 
     * @return The tax documents required in your Amazon Web Services Region.
     */
    public final TaxDocuments taxDocuments() {
        return taxDocuments;
    }

    /**
     * <p>
     * Defines the device configuration for an Snowcone job.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @return Defines the device configuration for an Snowcone job.</p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     */
    public final DeviceConfiguration deviceConfiguration() {
        return deviceConfiguration;
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When
     * set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device
     * arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #remoteManagement}
     * will return {@link RemoteManagement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #remoteManagementAsString}.
     * </p>
     * 
     * @return Allows you to securely operate and manage Snowcone devices remotely from outside of your internal
     *         network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available
     *         when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the
     *         device.
     * @see RemoteManagement
     */
    public final RemoteManagement remoteManagement() {
        return RemoteManagement.fromValue(remoteManagement);
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When
     * set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device
     * arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #remoteManagement}
     * will return {@link RemoteManagement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #remoteManagementAsString}.
     * </p>
     * 
     * @return Allows you to securely operate and manage Snowcone devices remotely from outside of your internal
     *         network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available
     *         when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the
     *         device.
     * @see RemoteManagement
     */
    public final String remoteManagementAsString() {
        return remoteManagement;
    }

    /**
     * <p>
     * The ID of the long-term pricing type for the device.
     * </p>
     * 
     * @return The ID of the long-term pricing type for the device.
     */
    public final String longTermPricingId() {
        return longTermPricingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(onDeviceServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(taxDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(remoteManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(longTermPricingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(resources(), other.resources())
                && Objects.equals(onDeviceServiceConfiguration(), other.onDeviceServiceConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(addressId(), other.addressId())
                && Objects.equals(kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString())
                && Objects.equals(shippingOptionAsString(), other.shippingOptionAsString())
                && Objects.equals(notification(), other.notification()) && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(snowballTypeAsString(), other.snowballTypeAsString())
                && Objects.equals(forwardingAddressId(), other.forwardingAddressId())
                && Objects.equals(taxDocuments(), other.taxDocuments())
                && Objects.equals(deviceConfiguration(), other.deviceConfiguration())
                && Objects.equals(remoteManagementAsString(), other.remoteManagementAsString())
                && Objects.equals(longTermPricingId(), other.longTermPricingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("JobType", jobTypeAsString()).add("Resources", resources())
                .add("OnDeviceServiceConfiguration", onDeviceServiceConfiguration()).add("Description", description())
                .add("AddressId", addressId()).add("KmsKeyARN", kmsKeyARN()).add("RoleARN", roleARN())
                .add("SnowballCapacityPreference", snowballCapacityPreferenceAsString())
                .add("ShippingOption", shippingOptionAsString()).add("Notification", notification())
                .add("ClusterId", clusterId()).add("SnowballType", snowballTypeAsString())
                .add("ForwardingAddressId", forwardingAddressId()).add("TaxDocuments", taxDocuments())
                .add("DeviceConfiguration", deviceConfiguration()).add("RemoteManagement", remoteManagementAsString())
                .add("LongTermPricingId", longTermPricingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "OnDeviceServiceConfiguration":
            return Optional.ofNullable(clazz.cast(onDeviceServiceConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AddressId":
            return Optional.ofNullable(clazz.cast(addressId()));
        case "KmsKeyARN":
            return Optional.ofNullable(clazz.cast(kmsKeyARN()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "SnowballCapacityPreference":
            return Optional.ofNullable(clazz.cast(snowballCapacityPreferenceAsString()));
        case "ShippingOption":
            return Optional.ofNullable(clazz.cast(shippingOptionAsString()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "SnowballType":
            return Optional.ofNullable(clazz.cast(snowballTypeAsString()));
        case "ForwardingAddressId":
            return Optional.ofNullable(clazz.cast(forwardingAddressId()));
        case "TaxDocuments":
            return Optional.ofNullable(clazz.cast(taxDocuments()));
        case "DeviceConfiguration":
            return Optional.ofNullable(clazz.cast(deviceConfiguration()));
        case "RemoteManagement":
            return Optional.ofNullable(clazz.cast(remoteManagementAsString()));
        case "LongTermPricingId":
            return Optional.ofNullable(clazz.cast(longTermPricingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * Defines the type of job that you're creating.
         * </p>
         * 
         * @param jobType
         *        Defines the type of job that you're creating.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Defines the type of job that you're creating.
         * </p>
         * 
         * @param jobType
         *        Defines the type of job that you're creating.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * Defines the Amazon S3 buckets associated with this job.
         * </p>
         * <p>
         * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
         * into.
         * </p>
         * <p>
         * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
         * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you
         * define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
         * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * 
         * @param resources
         *        Defines the Amazon S3 buckets associated with this job.</p>
         *        <p>
         *        With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
         *        imported into.
         *        </p>
         *        <p>
         *        With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
         *        exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export
         *        a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code>
         *        value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * Defines the Amazon S3 buckets associated with this job.
         * </p>
         * <p>
         * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
         * into.
         * </p>
         * <p>
         * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
         * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you
         * define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
         * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobResource.Builder} avoiding the need to
         * create one manually via {@link JobResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobResource.Builder#build()} is called immediately and its result
         * is passed to {@link #resources(JobResource)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link JobResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(JobResource)
         */
        default Builder resources(Consumer<JobResource.Builder> resources) {
            return resources(JobResource.builder().applyMutation(resources).build());
        }

        /**
         * <p>
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from
         * or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the
         * Amazon Web Services Storage Gateway service Tape Gateway type.
         * </p>
         * 
         * @param onDeviceServiceConfiguration
         *        Specifies the service or services on the Snow Family device that your transferred data will be
         *        exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network
         *        File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration);

        /**
         * <p>
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from
         * or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the
         * Amazon Web Services Storage Gateway service Tape Gateway type.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnDeviceServiceConfiguration.Builder}
         * avoiding the need to create one manually via {@link OnDeviceServiceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnDeviceServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #onDeviceServiceConfiguration(OnDeviceServiceConfiguration)}.
         * 
         * @param onDeviceServiceConfiguration
         *        a consumer that will call methods on {@link OnDeviceServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDeviceServiceConfiguration(OnDeviceServiceConfiguration)
         */
        default Builder onDeviceServiceConfiguration(Consumer<OnDeviceServiceConfiguration.Builder> onDeviceServiceConfiguration) {
            return onDeviceServiceConfiguration(OnDeviceServiceConfiguration.builder()
                    .applyMutation(onDeviceServiceConfiguration).build());
        }

        /**
         * <p>
         * Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * </p>
         * 
         * @param description
         *        Defines an optional description of this specific job, for example
         *        <code>Important Photos 2016-08-11</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID for the address that you want the Snow device shipped to.
         * </p>
         * 
         * @param addressId
         *        The ID for the address that you want the Snow device shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created
         * using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key
         * Management Service (KMS) API action.
         * </p>
         * 
         * @param kmsKeyARN
         *        The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are
         *        created using the <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key
         *        Management Service (KMS) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using
         * the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity
         * and Access Management (IAM) API action.
         * </p>
         * 
         * @param roleARN
         *        The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created
         *        using the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity
         *        and Access Management (IAM) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * If your job is being created in one of the US regions, you have the option of specifying what size Snow
         * device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * </p>
         * <p>
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
         * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
         * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
         * Capacity) in the <i>Snowcone User Guide</i>.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        If your job is being created in one of the US regions, you have the option of specifying what size
         *        Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage
         *        capacity.</p>
         *        <p>
         *        For more information, see
         *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i> or
         *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i>.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * If your job is being created in one of the US regions, you have the option of specifying what size Snow
         * device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * </p>
         * <p>
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
         * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
         * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
         * Capacity) in the <i>Snowcone User Guide</i>.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        If your job is being created in one of the US regions, you have the option of specifying what size
         *        Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage
         *        capacity.</p>
         *        <p>
         *        For more information, see
         *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i> or
         *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i>.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it
         * represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snow devices are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device,
         *        rather it represents how quickly the Snow device moves to its destination while in transit. Regional
         *        shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are
         *        delivered in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snow devices are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it
         * represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snow devices are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device,
         *        rather it represents how quickly the Snow device moves to its destination while in transit. Regional
         *        shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are
         *        delivered in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snow devices are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * </p>
         * 
         * @param notification
         *        Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * </p>
         * This is a convenience method that creates an instance of the {@link Notification.Builder} avoiding the need
         * to create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
         * <code>clusterId</code> value. The other job attributes are inherited from the cluster.
         * </p>
         * 
         * @param clusterId
         *        The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
         *        <code>clusterId</code> value. The other job attributes are inherited from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The type of Snow Family Devices to use for this job.
         * </p>
         * <note>
         * <p>
         * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
         * </p>
         * </note>
         * <p>
         * The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type
         * for cluster jobs is <code>EDGE</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge
         * Device Options</a> in the Snowball Edge Developer Guide.
         * </p>
         * <p>
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
         * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
         * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
         * Capacity) in the <i>Snowcone User Guide</i>.
         * </p>
         * 
         * @param snowballType
         *        The type of Snow Family Devices to use for this job. </p> <note>
         *        <p>
         *        For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
         *        type.
         *        </p>
         *        </note>
         *        <p>
         *        The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device
         *        type for cluster jobs is <code>EDGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball
         *        Edge Device Options</a> in the Snowball Edge Developer Guide.
         *        </p>
         *        <p>
         *        For more information, see
         *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i> or
         *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of Snow Family Devices to use for this job.
         * </p>
         * <note>
         * <p>
         * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
         * </p>
         * </note>
         * <p>
         * The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type
         * for cluster jobs is <code>EDGE</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge
         * Device Options</a> in the Snowball Edge Developer Guide.
         * </p>
         * <p>
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
         * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
         * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
         * Capacity) in the <i>Snowcone User Guide</i>.
         * </p>
         * 
         * @param snowballType
         *        The type of Snow Family Devices to use for this job. </p> <note>
         *        <p>
         *        For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
         *        type.
         *        </p>
         *        </note>
         *        <p>
         *        The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device
         *        type for cluster jobs is <code>EDGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball
         *        Edge Device Options</a> in the Snowball Edge Developer Guide.
         *        </p>
         *        <p>
         *        For more information, see
         *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i> or
         *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The forwarding address ID for a job. This field is not supported in most Regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The forwarding address ID for a job. This field is not supported in most Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);

        /**
         * <p>
         * The tax documents required in your Amazon Web Services Region.
         * </p>
         * 
         * @param taxDocuments
         *        The tax documents required in your Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocuments(TaxDocuments taxDocuments);

        /**
         * <p>
         * The tax documents required in your Amazon Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxDocuments.Builder} avoiding the need
         * to create one manually via {@link TaxDocuments#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaxDocuments.Builder#build()} is called immediately and its
         * result is passed to {@link #taxDocuments(TaxDocuments)}.
         * 
         * @param taxDocuments
         *        a consumer that will call methods on {@link TaxDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxDocuments(TaxDocuments)
         */
        default Builder taxDocuments(Consumer<TaxDocuments.Builder> taxDocuments) {
            return taxDocuments(TaxDocuments.builder().applyMutation(taxDocuments).build());
        }

        /**
         * <p>
         * Defines the device configuration for an Snowcone job.
         * </p>
         * <p>
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
         * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
         * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
         * Capacity) in the <i>Snowcone User Guide</i>.
         * </p>
         * 
         * @param deviceConfiguration
         *        Defines the device configuration for an Snowcone job.</p>
         *        <p>
         *        For more information, see
         *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i> or
         *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family
         *        Devices and Capacity) in the <i>Snowcone User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfiguration(DeviceConfiguration deviceConfiguration);

        /**
         * <p>
         * Defines the device configuration for an Snowcone job.
         * </p>
         * <p>
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
         * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
         * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
         * Capacity) in the <i>Snowcone User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceConfiguration.Builder} avoiding the
         * need to create one manually via {@link DeviceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceConfiguration(DeviceConfiguration)}.
         * 
         * @param deviceConfiguration
         *        a consumer that will call methods on {@link DeviceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfiguration(DeviceConfiguration)
         */
        default Builder deviceConfiguration(Consumer<DeviceConfiguration.Builder> deviceConfiguration) {
            return deviceConfiguration(DeviceConfiguration.builder().applyMutation(deviceConfiguration).build());
        }

        /**
         * <p>
         * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network.
         * When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
         * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
         * </p>
         * 
         * @param remoteManagement
         *        Allows you to securely operate and manage Snowcone devices remotely from outside of your internal
         *        network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be
         *        available when the device arrives at your location. Otherwise, you need to use the Snowball Client to
         *        manage the device.
         * @see RemoteManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemoteManagement
         */
        Builder remoteManagement(String remoteManagement);

        /**
         * <p>
         * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network.
         * When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
         * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
         * </p>
         * 
         * @param remoteManagement
         *        Allows you to securely operate and manage Snowcone devices remotely from outside of your internal
         *        network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be
         *        available when the device arrives at your location. Otherwise, you need to use the Snowball Client to
         *        manage the device.
         * @see RemoteManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemoteManagement
         */
        Builder remoteManagement(RemoteManagement remoteManagement);

        /**
         * <p>
         * The ID of the long-term pricing type for the device.
         * </p>
         * 
         * @param longTermPricingId
         *        The ID of the long-term pricing type for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longTermPricingId(String longTermPricingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String jobType;

        private JobResource resources;

        private OnDeviceServiceConfiguration onDeviceServiceConfiguration;

        private String description;

        private String addressId;

        private String kmsKeyARN;

        private String roleARN;

        private String snowballCapacityPreference;

        private String shippingOption;

        private Notification notification;

        private String clusterId;

        private String snowballType;

        private String forwardingAddressId;

        private TaxDocuments taxDocuments;

        private DeviceConfiguration deviceConfiguration;

        private String remoteManagement;

        private String longTermPricingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            jobType(model.jobType);
            resources(model.resources);
            onDeviceServiceConfiguration(model.onDeviceServiceConfiguration);
            description(model.description);
            addressId(model.addressId);
            kmsKeyARN(model.kmsKeyARN);
            roleARN(model.roleARN);
            snowballCapacityPreference(model.snowballCapacityPreference);
            shippingOption(model.shippingOption);
            notification(model.notification);
            clusterId(model.clusterId);
            snowballType(model.snowballType);
            forwardingAddressId(model.forwardingAddressId);
            taxDocuments(model.taxDocuments);
            deviceConfiguration(model.deviceConfiguration);
            remoteManagement(model.remoteManagement);
            longTermPricingId(model.longTermPricingId);
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final JobResource.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final OnDeviceServiceConfiguration.Builder getOnDeviceServiceConfiguration() {
            return onDeviceServiceConfiguration != null ? onDeviceServiceConfiguration.toBuilder() : null;
        }

        public final void setOnDeviceServiceConfiguration(OnDeviceServiceConfiguration.BuilderImpl onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration != null ? onDeviceServiceConfiguration.build()
                    : null;
        }

        @Override
        public final Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAddressId() {
            return addressId;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getSnowballCapacityPreference() {
            return snowballCapacityPreference;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference == null ? null : snowballCapacityPreference.toString());
            return this;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final TaxDocuments.Builder getTaxDocuments() {
            return taxDocuments != null ? taxDocuments.toBuilder() : null;
        }

        public final void setTaxDocuments(TaxDocuments.BuilderImpl taxDocuments) {
            this.taxDocuments = taxDocuments != null ? taxDocuments.build() : null;
        }

        @Override
        public final Builder taxDocuments(TaxDocuments taxDocuments) {
            this.taxDocuments = taxDocuments;
            return this;
        }

        public final DeviceConfiguration.Builder getDeviceConfiguration() {
            return deviceConfiguration != null ? deviceConfiguration.toBuilder() : null;
        }

        public final void setDeviceConfiguration(DeviceConfiguration.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfiguration deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final String getRemoteManagement() {
            return remoteManagement;
        }

        public final void setRemoteManagement(String remoteManagement) {
            this.remoteManagement = remoteManagement;
        }

        @Override
        public final Builder remoteManagement(String remoteManagement) {
            this.remoteManagement = remoteManagement;
            return this;
        }

        @Override
        public final Builder remoteManagement(RemoteManagement remoteManagement) {
            this.remoteManagement(remoteManagement == null ? null : remoteManagement.toString());
            return this;
        }

        public final String getLongTermPricingId() {
            return longTermPricingId;
        }

        public final void setLongTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
        }

        @Override
        public final Builder longTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
