/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTransfer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTransfer> {
    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesTransferred").getter(DataTransfer.getter(DataTransfer::bytesTransferred)).setter(DataTransfer.setter(Builder::bytesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()}).build();
    private static final SdkField<Long> OBJECTS_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ObjectsTransferred").getter(DataTransfer.getter(DataTransfer::objectsTransferred)).setter(DataTransfer.setter(Builder::objectsTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectsTransferred").build()}).build();
    private static final SdkField<Long> TOTAL_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalBytes").getter(DataTransfer.getter(DataTransfer::totalBytes)).setter(DataTransfer.setter(Builder::totalBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBytes").build()}).build();
    private static final SdkField<Long> TOTAL_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalObjects").getter(DataTransfer.getter(DataTransfer::totalObjects)).setter(DataTransfer.setter(Builder::totalObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalObjects").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_TRANSFERRED_FIELD, OBJECTS_TRANSFERRED_FIELD, TOTAL_BYTES_FIELD, TOTAL_OBJECTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long bytesTransferred;
    private final Long objectsTransferred;
    private final Long totalBytes;
    private final Long totalObjects;

    private DataTransfer(BuilderImpl builder) {
        this.bytesTransferred = builder.bytesTransferred;
        this.objectsTransferred = builder.objectsTransferred;
        this.totalBytes = builder.totalBytes;
        this.totalObjects = builder.totalObjects;
    }

    public final Long bytesTransferred() {
        return this.bytesTransferred;
    }

    public final Long objectsTransferred() {
        return this.objectsTransferred;
    }

    public final Long totalBytes() {
        return this.totalBytes;
    }

    public final Long totalObjects() {
        return this.totalObjects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectsTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalObjects());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransfer)) {
            return false;
        }
        DataTransfer other = (DataTransfer)obj;
        return Objects.equals(this.bytesTransferred(), other.bytesTransferred()) && Objects.equals(this.objectsTransferred(), other.objectsTransferred()) && Objects.equals(this.totalBytes(), other.totalBytes()) && Objects.equals(this.totalObjects(), other.totalObjects());
    }

    public final String toString() {
        return ToString.builder((String)"DataTransfer").add("BytesTransferred", (Object)this.bytesTransferred()).add("ObjectsTransferred", (Object)this.objectsTransferred()).add("TotalBytes", (Object)this.totalBytes()).add("TotalObjects", (Object)this.totalObjects()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BytesTransferred": {
                return Optional.ofNullable(clazz.cast(this.bytesTransferred()));
            }
            case "ObjectsTransferred": {
                return Optional.ofNullable(clazz.cast(this.objectsTransferred()));
            }
            case "TotalBytes": {
                return Optional.ofNullable(clazz.cast(this.totalBytes()));
            }
            case "TotalObjects": {
                return Optional.ofNullable(clazz.cast(this.totalObjects()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataTransfer, T> g) {
        return obj -> g.apply((DataTransfer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long bytesTransferred;
        private Long objectsTransferred;
        private Long totalBytes;
        private Long totalObjects;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransfer model) {
            this.bytesTransferred(model.bytesTransferred);
            this.objectsTransferred(model.objectsTransferred);
            this.totalBytes(model.totalBytes);
            this.totalObjects(model.totalObjects);
        }

        public final Long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        @Override
        @Transient
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final Long getObjectsTransferred() {
            return this.objectsTransferred;
        }

        public final void setObjectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
        }

        @Override
        @Transient
        public final Builder objectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
            return this;
        }

        public final Long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
        }

        @Override
        @Transient
        public final Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public final Long getTotalObjects() {
            return this.totalObjects;
        }

        public final void setTotalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
        }

        @Override
        @Transient
        public final Builder totalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
            return this;
        }

        public DataTransfer build() {
            return new DataTransfer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTransfer> {
        public Builder bytesTransferred(Long var1);

        public Builder objectsTransferred(Long var1);

        public Builder totalBytes(Long var1);

        public Builder totalObjects(Long var1);
    }
}

