/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReturnShippingLabelResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeReturnShippingLabelResponse.Builder, DescribeReturnShippingLabelResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeReturnShippingLabelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate").getter(getter(DescribeReturnShippingLabelResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            EXPIRATION_DATE_FIELD));

    private final String status;

    private final Instant expirationDate;

    private DescribeReturnShippingLabelResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * The status information of the task on a Snow device that is being returned to AWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShippingLabelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status information of the task on a Snow device that is being returned to AWS.
     * @see ShippingLabelStatus
     */
    public final ShippingLabelStatus status() {
        return ShippingLabelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status information of the task on a Snow device that is being returned to AWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShippingLabelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status information of the task on a Snow device that is being returned to AWS.
     * @see ShippingLabelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The expiration date of the current return shipping label.
     * </p>
     * 
     * @return The expiration date of the current return shipping label.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReturnShippingLabelResponse)) {
            return false;
        }
        DescribeReturnShippingLabelResponse other = (DescribeReturnShippingLabelResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(expirationDate(), other.expirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReturnShippingLabelResponse").add("Status", statusAsString())
                .add("ExpirationDate", expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReturnShippingLabelResponse, T> g) {
        return obj -> g.apply((DescribeReturnShippingLabelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReturnShippingLabelResponse> {
        /**
         * <p>
         * The status information of the task on a Snow device that is being returned to AWS.
         * </p>
         * 
         * @param status
         *        The status information of the task on a Snow device that is being returned to AWS.
         * @see ShippingLabelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingLabelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status information of the task on a Snow device that is being returned to AWS.
         * </p>
         * 
         * @param status
         *        The status information of the task on a Snow device that is being returned to AWS.
         * @see ShippingLabelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingLabelStatus
         */
        Builder status(ShippingLabelStatus status);

        /**
         * <p>
         * The expiration date of the current return shipping label.
         * </p>
         * 
         * @param expirationDate
         *        The expiration date of the current return shipping label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String status;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReturnShippingLabelResponse model) {
            super(model);
            status(model.status);
            expirationDate(model.expirationDate);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ShippingLabelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        @Transient
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public DescribeReturnShippingLabelResponse build() {
            return new DescribeReturnShippingLabelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
