/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShippingDetails implements SdkPojo, Serializable, ToCopyableBuilder<ShippingDetails.Builder, ShippingDetails> {
    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShippingOption").getter(getter(ShippingDetails::shippingOptionAsString))
            .setter(setter(Builder::shippingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()).build();

    private static final SdkField<Shipment> INBOUND_SHIPMENT_FIELD = SdkField.<Shipment> builder(MarshallingType.SDK_POJO)
            .memberName("InboundShipment").getter(getter(ShippingDetails::inboundShipment))
            .setter(setter(Builder::inboundShipment)).constructor(Shipment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundShipment").build()).build();

    private static final SdkField<Shipment> OUTBOUND_SHIPMENT_FIELD = SdkField.<Shipment> builder(MarshallingType.SDK_POJO)
            .memberName("OutboundShipment").getter(getter(ShippingDetails::outboundShipment))
            .setter(setter(Builder::outboundShipment)).constructor(Shipment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundShipment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHIPPING_OPTION_FIELD,
            INBOUND_SHIPMENT_FIELD, OUTBOUND_SHIPMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shippingOption;

    private final Shipment inboundShipment;

    private final Shipment outboundShipment;

    private ShippingDetails(BuilderImpl builder) {
        this.shippingOption = builder.shippingOption;
        this.inboundShipment = builder.inboundShipment;
        this.outboundShipment = builder.outboundShipment;
    }

    /**
     * <p>
     * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the
     * job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device
     *         from the job's creation date. This speed represents how quickly it moves to its destination while in
     *         transit. Regional shipping speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *         in about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *         are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *         which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snow devices are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public final ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the
     * job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device
     *         from the job's creation date. This speed represents how quickly it moves to its destination while in
     *         transit. Regional shipping speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *         in about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *         are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *         which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snow devices are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public final String shippingOptionAsString() {
        return shippingOption;
    }

    /**
     * <p>
     * The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to AWS for a
     * particular job.
     * </p>
     * 
     * @return The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to AWS
     *         for a particular job.
     */
    public final Shipment inboundShipment() {
        return inboundShipment;
    }

    /**
     * <p>
     * The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the address
     * that you specified for a particular job.
     * </p>
     * 
     * @return The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the
     *         address that you specified for a particular job.
     */
    public final Shipment outboundShipment() {
        return outboundShipment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inboundShipment());
        hashCode = 31 * hashCode + Objects.hashCode(outboundShipment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShippingDetails)) {
            return false;
        }
        ShippingDetails other = (ShippingDetails) obj;
        return Objects.equals(shippingOptionAsString(), other.shippingOptionAsString())
                && Objects.equals(inboundShipment(), other.inboundShipment())
                && Objects.equals(outboundShipment(), other.outboundShipment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShippingDetails").add("ShippingOption", shippingOptionAsString())
                .add("InboundShipment", inboundShipment()).add("OutboundShipment", outboundShipment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShippingOption":
            return Optional.ofNullable(clazz.cast(shippingOptionAsString()));
        case "InboundShipment":
            return Optional.ofNullable(clazz.cast(inboundShipment()));
        case "OutboundShipment":
            return Optional.ofNullable(clazz.cast(outboundShipment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShippingDetails, T> g) {
        return obj -> g.apply((ShippingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShippingDetails> {
        /**
         * <p>
         * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from
         * the job's creation date. This speed represents how quickly it moves to its destination while in transit.
         * Regional shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snow devices are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the United States of America (US), you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow
         *        device from the job's creation date. This speed represents how quickly it moves to its destination
         *        while in transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are
         *        delivered in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snow devices are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from
         * the job's creation date. This speed represents how quickly it moves to its destination while in transit.
         * Regional shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snow devices are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the United States of America (US), you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow
         *        device from the job's creation date. This speed represents how quickly it moves to its destination
         *        while in transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are
         *        delivered in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snow devices are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to AWS for a
         * particular job.
         * </p>
         * 
         * @param inboundShipment
         *        The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to AWS
         *        for a particular job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundShipment(Shipment inboundShipment);

        /**
         * <p>
         * The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to AWS for a
         * particular job.
         * </p>
         * This is a convenience that creates an instance of the {@link Shipment.Builder} avoiding the need to create
         * one manually via {@link Shipment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Shipment.Builder#build()} is called immediately and its result is
         * passed to {@link #inboundShipment(Shipment)}.
         * 
         * @param inboundShipment
         *        a consumer that will call methods on {@link Shipment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundShipment(Shipment)
         */
        default Builder inboundShipment(Consumer<Shipment.Builder> inboundShipment) {
            return inboundShipment(Shipment.builder().applyMutation(inboundShipment).build());
        }

        /**
         * <p>
         * The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the
         * address that you specified for a particular job.
         * </p>
         * 
         * @param outboundShipment
         *        The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to
         *        the address that you specified for a particular job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundShipment(Shipment outboundShipment);

        /**
         * <p>
         * The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the
         * address that you specified for a particular job.
         * </p>
         * This is a convenience that creates an instance of the {@link Shipment.Builder} avoiding the need to create
         * one manually via {@link Shipment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Shipment.Builder#build()} is called immediately and its result is
         * passed to {@link #outboundShipment(Shipment)}.
         * 
         * @param outboundShipment
         *        a consumer that will call methods on {@link Shipment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundShipment(Shipment)
         */
        default Builder outboundShipment(Consumer<Shipment.Builder> outboundShipment) {
            return outboundShipment(Shipment.builder().applyMutation(outboundShipment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String shippingOption;

        private Shipment inboundShipment;

        private Shipment outboundShipment;

        private BuilderImpl() {
        }

        private BuilderImpl(ShippingDetails model) {
            shippingOption(model.shippingOption);
            inboundShipment(model.inboundShipment);
            outboundShipment(model.outboundShipment);
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        @Override
        @Transient
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        @Transient
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final Shipment.Builder getInboundShipment() {
            return inboundShipment != null ? inboundShipment.toBuilder() : null;
        }

        public final void setInboundShipment(Shipment.BuilderImpl inboundShipment) {
            this.inboundShipment = inboundShipment != null ? inboundShipment.build() : null;
        }

        @Override
        @Transient
        public final Builder inboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
            return this;
        }

        public final Shipment.Builder getOutboundShipment() {
            return outboundShipment != null ? outboundShipment.toBuilder() : null;
        }

        public final void setOutboundShipment(Shipment.BuilderImpl outboundShipment) {
            this.outboundShipment = outboundShipment != null ? outboundShipment.build() : null;
        }

        @Override
        @Transient
        public final Builder outboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
            return this;
        }

        @Override
        public ShippingDetails build() {
            return new ShippingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
