/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the wireless connection on an AWS Snowcone device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WirelessConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<WirelessConnection.Builder, WirelessConnection> {
    private static final SdkField<Boolean> IS_WIFI_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsWifiEnabled").getter(getter(WirelessConnection::isWifiEnabled)).setter(setter(Builder::isWifiEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsWifiEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_WIFI_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isWifiEnabled;

    private WirelessConnection(BuilderImpl builder) {
        this.isWifiEnabled = builder.isWifiEnabled;
    }

    /**
     * <p>
     * Enables the Wi-Fi adapter on an AWS Snowcone device.
     * </p>
     * 
     * @return Enables the Wi-Fi adapter on an AWS Snowcone device.
     */
    public final Boolean isWifiEnabled() {
        return isWifiEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isWifiEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessConnection)) {
            return false;
        }
        WirelessConnection other = (WirelessConnection) obj;
        return Objects.equals(isWifiEnabled(), other.isWifiEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WirelessConnection").add("IsWifiEnabled", isWifiEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsWifiEnabled":
            return Optional.ofNullable(clazz.cast(isWifiEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WirelessConnection, T> g) {
        return obj -> g.apply((WirelessConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WirelessConnection> {
        /**
         * <p>
         * Enables the Wi-Fi adapter on an AWS Snowcone device.
         * </p>
         * 
         * @param isWifiEnabled
         *        Enables the Wi-Fi adapter on an AWS Snowcone device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isWifiEnabled(Boolean isWifiEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isWifiEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessConnection model) {
            isWifiEnabled(model.isWifiEnabled);
        }

        public final Boolean getIsWifiEnabled() {
            return isWifiEnabled;
        }

        public final void setIsWifiEnabled(Boolean isWifiEnabled) {
            this.isWifiEnabled = isWifiEnabled;
        }

        @Override
        @Transient
        public final Builder isWifiEnabled(Boolean isWifiEnabled) {
            this.isWifiEnabled = isWifiEnabled;
            return this;
        }

        @Override
        public WirelessConnection build() {
            return new WirelessConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
