/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLongTermPricingResponse extends SnowballResponse implements
        ToCopyableBuilder<ListLongTermPricingResponse.Builder, ListLongTermPricingResponse> {
    private static final SdkField<List<LongTermPricingListEntry>> LONG_TERM_PRICING_ENTRIES_FIELD = SdkField
            .<List<LongTermPricingListEntry>> builder(MarshallingType.LIST)
            .memberName("LongTermPricingEntries")
            .getter(getter(ListLongTermPricingResponse::longTermPricingEntries))
            .setter(setter(Builder::longTermPricingEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LongTermPricingListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(LongTermPricingListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLongTermPricingResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LONG_TERM_PRICING_ENTRIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<LongTermPricingListEntry> longTermPricingEntries;

    private final String nextToken;

    private ListLongTermPricingResponse(BuilderImpl builder) {
        super(builder);
        this.longTermPricingEntries = builder.longTermPricingEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LongTermPricingEntries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLongTermPricingEntries() {
        return longTermPricingEntries != null && !(longTermPricingEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
     * <code>LongTermPricing</code> type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLongTermPricingEntries} method.
     * </p>
     * 
     * @return Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
     *         <code>LongTermPricing</code> type.
     */
    public final List<LongTermPricingListEntry> longTermPricingEntries() {
        return longTermPricingEntries;
    }

    /**
     * <p>
     * Because HTTP requests are stateless, this is the starting point for your next list of returned
     * <code>ListLongTermPricing</code> list.
     * </p>
     * 
     * @return Because HTTP requests are stateless, this is the starting point for your next list of returned
     *         <code>ListLongTermPricing</code> list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLongTermPricingEntries() ? longTermPricingEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLongTermPricingResponse)) {
            return false;
        }
        ListLongTermPricingResponse other = (ListLongTermPricingResponse) obj;
        return hasLongTermPricingEntries() == other.hasLongTermPricingEntries()
                && Objects.equals(longTermPricingEntries(), other.longTermPricingEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLongTermPricingResponse")
                .add("LongTermPricingEntries", hasLongTermPricingEntries() ? longTermPricingEntries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LongTermPricingEntries":
            return Optional.ofNullable(clazz.cast(longTermPricingEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLongTermPricingResponse, T> g) {
        return obj -> g.apply((ListLongTermPricingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLongTermPricingResponse> {
        /**
         * <p>
         * Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
         * <code>LongTermPricing</code> type.
         * </p>
         * 
         * @param longTermPricingEntries
         *        Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
         *        <code>LongTermPricing</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longTermPricingEntries(Collection<LongTermPricingListEntry> longTermPricingEntries);

        /**
         * <p>
         * Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
         * <code>LongTermPricing</code> type.
         * </p>
         * 
         * @param longTermPricingEntries
         *        Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
         *        <code>LongTermPricing</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longTermPricingEntries(LongTermPricingListEntry... longTermPricingEntries);

        /**
         * <p>
         * Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the
         * <code>LongTermPricing</code> type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LongTermPricingListEntry>.Builder} avoiding
         * the need to create one manually via {@link List<LongTermPricingListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LongTermPricingListEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #longTermPricingEntries(List<LongTermPricingListEntry>)}.
         * 
         * @param longTermPricingEntries
         *        a consumer that will call methods on {@link List<LongTermPricingListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #longTermPricingEntries(List<LongTermPricingListEntry>)
         */
        Builder longTermPricingEntries(Consumer<LongTermPricingListEntry.Builder>... longTermPricingEntries);

        /**
         * <p>
         * Because HTTP requests are stateless, this is the starting point for your next list of returned
         * <code>ListLongTermPricing</code> list.
         * </p>
         * 
         * @param nextToken
         *        Because HTTP requests are stateless, this is the starting point for your next list of returned
         *        <code>ListLongTermPricing</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<LongTermPricingListEntry> longTermPricingEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLongTermPricingResponse model) {
            super(model);
            longTermPricingEntries(model.longTermPricingEntries);
            nextToken(model.nextToken);
        }

        public final List<LongTermPricingListEntry.Builder> getLongTermPricingEntries() {
            List<LongTermPricingListEntry.Builder> result = LongTermPricingEntryListCopier
                    .copyToBuilder(this.longTermPricingEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLongTermPricingEntries(Collection<LongTermPricingListEntry.BuilderImpl> longTermPricingEntries) {
            this.longTermPricingEntries = LongTermPricingEntryListCopier.copyFromBuilder(longTermPricingEntries);
        }

        @Override
        @Transient
        public final Builder longTermPricingEntries(Collection<LongTermPricingListEntry> longTermPricingEntries) {
            this.longTermPricingEntries = LongTermPricingEntryListCopier.copy(longTermPricingEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder longTermPricingEntries(LongTermPricingListEntry... longTermPricingEntries) {
            longTermPricingEntries(Arrays.asList(longTermPricingEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder longTermPricingEntries(Consumer<LongTermPricingListEntry.Builder>... longTermPricingEntries) {
            longTermPricingEntries(Stream.of(longTermPricingEntries)
                    .map(c -> LongTermPricingListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLongTermPricingResponse build() {
            return new ListLongTermPricingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
