/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaResource implements SdkPojo, Serializable, ToCopyableBuilder<LambdaResource.Builder, LambdaResource> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaResource::lambdaArn)).setter(setter(Builder::lambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaArn").build()).build();

    private static final SdkField<List<EventTriggerDefinition>> EVENT_TRIGGERS_FIELD = SdkField
            .<List<EventTriggerDefinition>> builder(MarshallingType.LIST)
            .getter(getter(LambdaResource::eventTriggers))
            .setter(setter(Builder::eventTriggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTriggerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTriggerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD,
            EVENT_TRIGGERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lambdaArn;

    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on the
     * associated local Amazon S3 resource.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object
     *         actions on the associated local Amazon S3 resource.
     */
    public String lambdaArn() {
        return lambdaArn;
    }

    /**
     * <p>
     * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with this
     * job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated
     *         with this job.
     */
    public List<EventTriggerDefinition> eventTriggers() {
        return eventTriggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventTriggers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource) obj;
        return Objects.equals(lambdaArn(), other.lambdaArn()) && Objects.equals(eventTriggers(), other.eventTriggers());
    }

    @Override
    public String toString() {
        return ToString.builder("LambdaResource").add("LambdaArn", lambdaArn()).add("EventTriggers", eventTriggers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaArn":
            return Optional.ofNullable(clazz.cast(lambdaArn()));
        case "EventTriggers":
            return Optional.ofNullable(clazz.cast(eventTriggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaResource, T> g) {
        return obj -> g.apply((LambdaResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on
         * the associated local Amazon S3 resource.
         * </p>
         * 
         * @param lambdaArn
         *        An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object
         *        actions on the associated local Amazon S3 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(EventTriggerDefinition... eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventTriggerDefinition>.Builder} avoiding
         * the need to create one manually via {@link List<EventTriggerDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventTriggerDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #eventTriggers(List<EventTriggerDefinition>)}.
         * 
         * @param eventTriggers
         *        a consumer that will call methods on {@link List<EventTriggerDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTriggers(List<EventTriggerDefinition>)
         */
        Builder eventTriggers(Consumer<EventTriggerDefinition.Builder>... eventTriggers);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaArn;

        private List<EventTriggerDefinition> eventTriggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            lambdaArn(model.lambdaArn);
            eventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        public final Collection<EventTriggerDefinition.Builder> getEventTriggers() {
            return eventTriggers != null ? eventTriggers.stream().map(EventTriggerDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition... eventTriggers) {
            eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(Consumer<EventTriggerDefinition.Builder>... eventTriggers) {
            eventTriggers(Stream.of(eventTriggers).map(c -> EventTriggerDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition.BuilderImpl> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copyFromBuilder(eventTriggers);
        }

        @Override
        public LambdaResource build() {
            return new LambdaResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
