/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Status</code> and <code>TrackingNumber</code> information for an inbound or outbound shipment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Shipment implements SdkPojo, Serializable, ToCopyableBuilder<Shipment.Builder, Shipment> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Shipment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TRACKING_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Shipment::trackingNumber)).setter(setter(Builder::trackingNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            TRACKING_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String trackingNumber;

    private Shipment(BuilderImpl builder) {
        this.status = builder.status;
        this.trackingNumber = builder.trackingNumber;
    }

    /**
     * <p>
     * Status information for a shipment.
     * </p>
     * 
     * @return Status information for a shipment.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The tracking number for this job. Using this tracking number with your region's carrier's website, you can track
     * a Snowball as the carrier transports it.
     * </p>
     * <p>
     * For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
     * </p>
     * 
     * @return The tracking number for this job. Using this tracking number with your region's carrier's website, you
     *         can track a Snowball as the carrier transports it.</p>
     *         <p>
     *         For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
     */
    public String trackingNumber() {
        return trackingNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(trackingNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shipment)) {
            return false;
        }
        Shipment other = (Shipment) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(trackingNumber(), other.trackingNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("Shipment").add("Status", status()).add("TrackingNumber", trackingNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "TrackingNumber":
            return Optional.ofNullable(clazz.cast(trackingNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Shipment, T> g) {
        return obj -> g.apply((Shipment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Shipment> {
        /**
         * <p>
         * Status information for a shipment.
         * </p>
         * 
         * @param status
         *        Status information for a shipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The tracking number for this job. Using this tracking number with your region's carrier's website, you can
         * track a Snowball as the carrier transports it.
         * </p>
         * <p>
         * For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
         * </p>
         * 
         * @param trackingNumber
         *        The tracking number for this job. Using this tracking number with your region's carrier's website, you
         *        can track a Snowball as the carrier transports it.</p>
         *        <p>
         *        For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingNumber(String trackingNumber);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String trackingNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Shipment model) {
            status(model.status);
            trackingNumber(model.trackingNumber);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTrackingNumber() {
            return trackingNumber;
        }

        @Override
        public final Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public final void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        @Override
        public Shipment build() {
            return new Shipment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
