/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.model.CompatibleImage;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse;

public class ListCompatibleImagesIterable
implements SdkIterable<ListCompatibleImagesResponse> {
    private final SnowballClient client;
    private final ListCompatibleImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCompatibleImagesIterable(SnowballClient client, ListCompatibleImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCompatibleImagesResponseFetcher();
    }

    public Iterator<ListCompatibleImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CompatibleImage> compatibleImages() {
        Function<ListCompatibleImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.compatibleImages() != null) {
                return response.compatibleImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCompatibleImagesResponseFetcher
    implements SyncPageFetcher<ListCompatibleImagesResponse> {
        private ListCompatibleImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListCompatibleImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCompatibleImagesResponse nextPage(ListCompatibleImagesResponse previousPage) {
            if (previousPage == null) {
                return ListCompatibleImagesIterable.this.client.listCompatibleImages(ListCompatibleImagesIterable.this.firstRequest);
            }
            return ListCompatibleImagesIterable.this.client.listCompatibleImages((ListCompatibleImagesRequest)((Object)ListCompatibleImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

