/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name and version of the service dependant on the requested service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DependentService implements SdkPojo, Serializable,
        ToCopyableBuilder<DependentService.Builder, DependentService> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(DependentService::serviceNameAsString)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<ServiceVersion> SERVICE_VERSION_FIELD = SdkField
            .<ServiceVersion> builder(MarshallingType.SDK_POJO).memberName("ServiceVersion")
            .getter(getter(DependentService::serviceVersion)).setter(setter(Builder::serviceVersion))
            .constructor(ServiceVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            SERVICE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final ServiceVersion serviceVersion;

    private DependentService(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceVersion = builder.serviceVersion;
    }

    /**
     * <p>
     * The name of the dependent service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the dependent service.
     * @see ServiceName
     */
    public final ServiceName serviceName() {
        return ServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * The name of the dependent service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the dependent service.
     * @see ServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    /**
     * <p>
     * The version of the dependent service.
     * </p>
     * 
     * @return The version of the dependent service.
     */
    public final ServiceVersion serviceVersion() {
        return serviceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependentService)) {
            return false;
        }
        DependentService other = (DependentService) obj;
        return Objects.equals(serviceNameAsString(), other.serviceNameAsString())
                && Objects.equals(serviceVersion(), other.serviceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DependentService").add("ServiceName", serviceNameAsString())
                .add("ServiceVersion", serviceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        case "ServiceVersion":
            return Optional.ofNullable(clazz.cast(serviceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DependentService, T> g) {
        return obj -> g.apply((DependentService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DependentService> {
        /**
         * <p>
         * The name of the dependent service.
         * </p>
         * 
         * @param serviceName
         *        The name of the dependent service.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the dependent service.
         * </p>
         * 
         * @param serviceName
         *        The name of the dependent service.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(ServiceName serviceName);

        /**
         * <p>
         * The version of the dependent service.
         * </p>
         * 
         * @param serviceVersion
         *        The version of the dependent service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceVersion(ServiceVersion serviceVersion);

        /**
         * <p>
         * The version of the dependent service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceVersion.Builder} avoiding the need
         * to create one manually via {@link ServiceVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceVersion(ServiceVersion)}.
         * 
         * @param serviceVersion
         *        a consumer that will call methods on {@link ServiceVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceVersion(ServiceVersion)
         */
        default Builder serviceVersion(Consumer<ServiceVersion.Builder> serviceVersion) {
            return serviceVersion(ServiceVersion.builder().applyMutation(serviceVersion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private ServiceVersion serviceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DependentService model) {
            serviceName(model.serviceName);
            serviceVersion(model.serviceVersion);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final ServiceVersion.Builder getServiceVersion() {
            return serviceVersion != null ? serviceVersion.toBuilder() : null;
        }

        public final void setServiceVersion(ServiceVersion.BuilderImpl serviceVersion) {
            this.serviceVersion = serviceVersion != null ? serviceVersion.build() : null;
        }

        @Override
        public final Builder serviceVersion(ServiceVersion serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        @Override
        public DependentService build() {
            return new DependentService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
