/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the metadata and configuration settings of EKS Anywhere on the Snow Family device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EKSOnDeviceServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EKSOnDeviceServiceConfiguration.Builder, EKSOnDeviceServiceConfiguration> {
    private static final SdkField<String> KUBERNETES_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KubernetesVersion").getter(getter(EKSOnDeviceServiceConfiguration::kubernetesVersion))
            .setter(setter(Builder::kubernetesVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KubernetesVersion").build()).build();

    private static final SdkField<String> EKS_ANYWHERE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EKSAnywhereVersion").getter(getter(EKSOnDeviceServiceConfiguration::eksAnywhereVersion))
            .setter(setter(Builder::eksAnywhereVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EKSAnywhereVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KUBERNETES_VERSION_FIELD,
            EKS_ANYWHERE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kubernetesVersion;

    private final String eksAnywhereVersion;

    private EKSOnDeviceServiceConfiguration(BuilderImpl builder) {
        this.kubernetesVersion = builder.kubernetesVersion;
        this.eksAnywhereVersion = builder.eksAnywhereVersion;
    }

    /**
     * <p>
     * The Kubernetes version for EKS Anywhere on the Snow Family device.
     * </p>
     * 
     * @return The Kubernetes version for EKS Anywhere on the Snow Family device.
     */
    public final String kubernetesVersion() {
        return kubernetesVersion;
    }

    /**
     * <p>
     * The optional version of EKS Anywhere on the Snow Family device.
     * </p>
     * 
     * @return The optional version of EKS Anywhere on the Snow Family device.
     */
    public final String eksAnywhereVersion() {
        return eksAnywhereVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesVersion());
        hashCode = 31 * hashCode + Objects.hashCode(eksAnywhereVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EKSOnDeviceServiceConfiguration)) {
            return false;
        }
        EKSOnDeviceServiceConfiguration other = (EKSOnDeviceServiceConfiguration) obj;
        return Objects.equals(kubernetesVersion(), other.kubernetesVersion())
                && Objects.equals(eksAnywhereVersion(), other.eksAnywhereVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EKSOnDeviceServiceConfiguration").add("KubernetesVersion", kubernetesVersion())
                .add("EKSAnywhereVersion", eksAnywhereVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KubernetesVersion":
            return Optional.ofNullable(clazz.cast(kubernetesVersion()));
        case "EKSAnywhereVersion":
            return Optional.ofNullable(clazz.cast(eksAnywhereVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EKSOnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((EKSOnDeviceServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EKSOnDeviceServiceConfiguration> {
        /**
         * <p>
         * The Kubernetes version for EKS Anywhere on the Snow Family device.
         * </p>
         * 
         * @param kubernetesVersion
         *        The Kubernetes version for EKS Anywhere on the Snow Family device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesVersion(String kubernetesVersion);

        /**
         * <p>
         * The optional version of EKS Anywhere on the Snow Family device.
         * </p>
         * 
         * @param eksAnywhereVersion
         *        The optional version of EKS Anywhere on the Snow Family device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksAnywhereVersion(String eksAnywhereVersion);
    }

    static final class BuilderImpl implements Builder {
        private String kubernetesVersion;

        private String eksAnywhereVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EKSOnDeviceServiceConfiguration model) {
            kubernetesVersion(model.kubernetesVersion);
            eksAnywhereVersion(model.eksAnywhereVersion);
        }

        public final String getKubernetesVersion() {
            return kubernetesVersion;
        }

        public final void setKubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
        }

        @Override
        public final Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            return this;
        }

        public final String getEksAnywhereVersion() {
            return eksAnywhereVersion;
        }

        public final void setEksAnywhereVersion(String eksAnywhereVersion) {
            this.eksAnywhereVersion = eksAnywhereVersion;
        }

        @Override
        public final Builder eksAnywhereVersion(String eksAnywhereVersion) {
            this.eksAnywhereVersion = eksAnywhereVersion;
            return this;
        }

        @Override
        public EKSOnDeviceServiceConfiguration build() {
            return new EKSOnDeviceServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
