/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterResponse extends SnowballResponse implements
        ToCopyableBuilder<CreateClusterResponse.Builder, CreateClusterResponse> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(CreateClusterResponse::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<List<JobListEntry>> JOB_LIST_ENTRIES_FIELD = SdkField
            .<List<JobListEntry>> builder(MarshallingType.LIST)
            .memberName("JobListEntries")
            .getter(getter(CreateClusterResponse::jobListEntries))
            .setter(setter(Builder::jobListEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobListEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            JOB_LIST_ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final List<JobListEntry> jobListEntries;

    private CreateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.jobListEntries = builder.jobListEntries;
    }

    /**
     * <p>
     * The automatically generated ID for a cluster.
     * </p>
     * 
     * @return The automatically generated ID for a cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobListEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobListEntries() {
        return jobListEntries != null && !(jobListEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of jobs created for this cluster. For syntax, see <a
     * href="http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
     * >ListJobsResult$JobListEntries</a> in this guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobListEntries} method.
     * </p>
     * 
     * @return List of jobs created for this cluster. For syntax, see <a
     *         href="http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
     *         >ListJobsResult$JobListEntries</a> in this guide.
     */
    public final List<JobListEntry> jobListEntries() {
        return jobListEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobListEntries() ? jobListEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterResponse)) {
            return false;
        }
        CreateClusterResponse other = (CreateClusterResponse) obj;
        return Objects.equals(clusterId(), other.clusterId()) && hasJobListEntries() == other.hasJobListEntries()
                && Objects.equals(jobListEntries(), other.jobListEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterResponse").add("ClusterId", clusterId())
                .add("JobListEntries", hasJobListEntries() ? jobListEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "JobListEntries":
            return Optional.ofNullable(clazz.cast(jobListEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("JobListEntries", JOB_LIST_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterResponse, T> g) {
        return obj -> g.apply((CreateClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterResponse> {
        /**
         * <p>
         * The automatically generated ID for a cluster.
         * </p>
         * 
         * @param clusterId
         *        The automatically generated ID for a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * List of jobs created for this cluster. For syntax, see <a
         * href="http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
         * >ListJobsResult$JobListEntries</a> in this guide.
         * </p>
         * 
         * @param jobListEntries
         *        List of jobs created for this cluster. For syntax, see <a href=
         *        "http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
         *        >ListJobsResult$JobListEntries</a> in this guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(Collection<JobListEntry> jobListEntries);

        /**
         * <p>
         * List of jobs created for this cluster. For syntax, see <a
         * href="http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
         * >ListJobsResult$JobListEntries</a> in this guide.
         * </p>
         * 
         * @param jobListEntries
         *        List of jobs created for this cluster. For syntax, see <a href=
         *        "http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
         *        >ListJobsResult$JobListEntries</a> in this guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(JobListEntry... jobListEntries);

        /**
         * <p>
         * List of jobs created for this cluster. For syntax, see <a
         * href="http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax"
         * >ListJobsResult$JobListEntries</a> in this guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.JobListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.snowball.model.JobListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.JobListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #jobListEntries(List<JobListEntry>)}.
         * 
         * @param jobListEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.JobListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobListEntries(java.util.Collection<JobListEntry>)
         */
        Builder jobListEntries(Consumer<JobListEntry.Builder>... jobListEntries);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String clusterId;

        private List<JobListEntry> jobListEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterResponse model) {
            super(model);
            clusterId(model.clusterId);
            jobListEntries(model.jobListEntries);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final List<JobListEntry.Builder> getJobListEntries() {
            List<JobListEntry.Builder> result = JobListEntryListCopier.copyToBuilder(this.jobListEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobListEntries(Collection<JobListEntry.BuilderImpl> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copyFromBuilder(jobListEntries);
        }

        @Override
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry... jobListEntries) {
            jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(Consumer<JobListEntry.Builder>... jobListEntries) {
            jobListEntries(Stream.of(jobListEntries).map(c -> JobListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateClusterResponse build() {
            return new CreateClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
