/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceVersionsRequest extends SnowballRequest implements
        ToCopyableBuilder<ListServiceVersionsRequest.Builder, ListServiceVersionsRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ListServiceVersionsRequest::serviceNameAsString))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<List<DependentService>> DEPENDENT_SERVICES_FIELD = SdkField
            .<List<DependentService>> builder(MarshallingType.LIST)
            .memberName("DependentServices")
            .getter(getter(ListServiceVersionsRequest::dependentServices))
            .setter(setter(Builder::dependentServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DependentService> builder(MarshallingType.SDK_POJO)
                                            .constructor(DependentService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListServiceVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            DEPENDENT_SERVICES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceName;

    private final List<DependentService> dependentServices;

    private final Integer maxResults;

    private final String nextToken;

    private ListServiceVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.dependentServices = builder.dependentServices;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the service for which you're requesting supported versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the service for which you're requesting supported versions.
     * @see ServiceName
     */
    public final ServiceName serviceName() {
        return ServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * The name of the service for which you're requesting supported versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the service for which you're requesting supported versions.
     * @see ServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependentServices property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependentServices() {
        return dependentServices != null && !(dependentServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names and versions of dependant services of the requested service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependentServices} method.
     * </p>
     * 
     * @return A list of names and versions of dependant services of the requested service.
     */
    public final List<DependentService> dependentServices() {
        return dependentServices;
    }

    /**
     * <p>
     * The maximum number of <code>ListServiceVersions</code> objects to return.
     * </p>
     * 
     * @return The maximum number of <code>ListServiceVersions</code> objects to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Because HTTP requests are stateless, this is the starting point for the next list of returned
     * <code>ListServiceVersionsRequest</code> versions.
     * </p>
     * 
     * @return Because HTTP requests are stateless, this is the starting point for the next list of returned
     *         <code>ListServiceVersionsRequest</code> versions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependentServices() ? dependentServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceVersionsRequest)) {
            return false;
        }
        ListServiceVersionsRequest other = (ListServiceVersionsRequest) obj;
        return Objects.equals(serviceNameAsString(), other.serviceNameAsString())
                && hasDependentServices() == other.hasDependentServices()
                && Objects.equals(dependentServices(), other.dependentServices())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceVersionsRequest").add("ServiceName", serviceNameAsString())
                .add("DependentServices", hasDependentServices() ? dependentServices() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        case "DependentServices":
            return Optional.ofNullable(clazz.cast(dependentServices()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("DependentServices", DEPENDENT_SERVICES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceVersionsRequest, T> g) {
        return obj -> g.apply((ListServiceVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceVersionsRequest> {
        /**
         * <p>
         * The name of the service for which you're requesting supported versions.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which you're requesting supported versions.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the service for which you're requesting supported versions.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which you're requesting supported versions.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(ServiceName serviceName);

        /**
         * <p>
         * A list of names and versions of dependant services of the requested service.
         * </p>
         * 
         * @param dependentServices
         *        A list of names and versions of dependant services of the requested service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependentServices(Collection<DependentService> dependentServices);

        /**
         * <p>
         * A list of names and versions of dependant services of the requested service.
         * </p>
         * 
         * @param dependentServices
         *        A list of names and versions of dependant services of the requested service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependentServices(DependentService... dependentServices);

        /**
         * <p>
         * A list of names and versions of dependant services of the requested service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.DependentService.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.snowball.model.DependentService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.DependentService.Builder#build()} is called immediately
         * and its result is passed to {@link #dependentServices(List<DependentService>)}.
         * 
         * @param dependentServices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.DependentService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependentServices(java.util.Collection<DependentService>)
         */
        Builder dependentServices(Consumer<DependentService.Builder>... dependentServices);

        /**
         * <p>
         * The maximum number of <code>ListServiceVersions</code> objects to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of <code>ListServiceVersions</code> objects to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Because HTTP requests are stateless, this is the starting point for the next list of returned
         * <code>ListServiceVersionsRequest</code> versions.
         * </p>
         * 
         * @param nextToken
         *        Because HTTP requests are stateless, this is the starting point for the next list of returned
         *        <code>ListServiceVersionsRequest</code> versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String serviceName;

        private List<DependentService> dependentServices = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceVersionsRequest model) {
            super(model);
            serviceName(model.serviceName);
            dependentServices(model.dependentServices);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final List<DependentService.Builder> getDependentServices() {
            List<DependentService.Builder> result = DependentServiceListCopier.copyToBuilder(this.dependentServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependentServices(Collection<DependentService.BuilderImpl> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copyFromBuilder(dependentServices);
        }

        @Override
        public final Builder dependentServices(Collection<DependentService> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copy(dependentServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(DependentService... dependentServices) {
            dependentServices(Arrays.asList(dependentServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(Consumer<DependentService.Builder>... dependentServices) {
            dependentServices(Stream.of(dependentServices).map(c -> DependentService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceVersionsRequest build() {
            return new ListServiceVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
